/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.mdm;

import com.biz.eisp.api.feign.CustomerFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.fee.TtFeeBudgetFeign;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.customer.TmCustomerResultVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/mdmCustomerController"})
@Controller
public class MdmCustomerController {
    @Autowired
    private CustomerFeign customerFeign;
    @Autowired
    private TtFeeBudgetFeign ttFeeBudgetFeign;

    @RequestMapping(value={"getTmCustomerEntityList"})
    @ResponseBody
    public Object getTmOrgEntityList(HttpServletRequest request, String customerCode, String customerName) {
        HashMap<String, String> param = new HashMap<String, String>();
        EuPage page = new EuPage(request);
        param.put("page", page.getPage());
        param.put("customerCode", customerCode);
        param.put("customerName", customerName);
        AjaxJson ajaxJson = this.customerFeign.getCustomerPage(param);
        if (null != ajaxJson) {
            if (null != ajaxJson.getPageInfo()) {
                return new DataGrid(ajaxJson.getPageInfo());
            }
            return new DataGrid(new ArrayList(), (Page)page);
        }
        AjaxJson j = new AjaxJson();
        j.setMsg("\u63a5\u53e3\u8bf7\u6c42\u6570\u636e\u5931\u8d25\uff01");
        j.setSuccess(false);
        return j;
    }

    @RequestMapping(value={"getTmActCustomerList"})
    @ResponseBody
    public Object getTmActCustomerList(HttpServletRequest request, String customerCode, String customerName, String budgetCode) {
        String posId = UserUtils.getUser().getPosId();
        HashMap<String, String> param = new HashMap<String, String>();
        EuPage page = new EuPage(request);
        param.put("page", page.getPage());
        param.put("customerCode", customerCode);
        param.put("customerName", customerName);
        param.put("posId", posId);
        AjaxJson ajaxJson = this.customerFeign.getCustomerByPosPage(param);
        TmCustomerResultVo tmCustomerResultVo = new TmCustomerResultVo();
        TtFeeBudgetEntity entity = new TtFeeBudgetEntity();
        if (StringUtil.isNotEmpty((CharSequence)budgetCode) && StringUtil.equals((String)(entity = (TtFeeBudgetEntity)this.ttFeeBudgetFeign.getEntity("", budgetCode).getObj()).getSubjectsGroupCode(), (String)ConstantEnum.feeBudgetGroupEnum.CUST.getValue())) {
            tmCustomerResultVo.setCustomerCode(entity.getCustCode());
            tmCustomerResultVo.setCustomerName(entity.getCustName());
        }
        if (null != ajaxJson) {
            if (null != ajaxJson.getPageInfo()) {
                if (StringUtil.equals((String)entity.getSubjectsGroupCode(), (String)ConstantEnum.feeBudgetGroupEnum.CUST.getValue())) {
                    List tmCustomerResultVos = ajaxJson.getPageInfo().getList();
                    List customerCodes = tmCustomerResultVos.stream().map(TmCustomerResultVo::getCustomerCode).collect(Collectors.toList());
                    if (customerCodes.contains(tmCustomerResultVo.getCustomerCode())) {
                        ArrayList<TmCustomerResultVo> resultVos = new ArrayList<TmCustomerResultVo>();
                        resultVos.add(tmCustomerResultVo);
                        return resultVos;
                    }
                    return new DataGrid(new ArrayList(), (Page)page);
                }
                return new DataGrid(ajaxJson.getPageInfo());
            }
            return new DataGrid(new ArrayList(), (Page)page);
        }
        AjaxJson j = new AjaxJson();
        j.setMsg("\u63a5\u53e3\u8bf7\u6c42\u6570\u636e\u5931\u8d25\uff01");
        j.setSuccess(false);
        return j;
    }
}

