/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.configure.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.configure.dao.KnlTableConfigDao;
import com.biz.eisp.base.configure.service.KnlTableInitService;
import com.biz.eisp.configure.entity.KnlTableConfigEntity;
import com.biz.eisp.service.RedisService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="knlTableInitService")
public class KnlTableInitServiceImpl
implements KnlTableInitService {
    @Autowired
    private KnlTableConfigDao knlTableConfigDao;
    @Autowired
    private RedisService redisService;

    @Override
    public void initTableConfigToRedis() {
        List entitys = this.knlTableConfigDao.selectAll();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entitys)) {
            entitys.forEach(entity -> this.redisService.hset("TABLE_CONFIG_" + entity.getFunctionId(), entity.getField(), entity));
        }
    }

    @Override
    public void initSync(List<KnlTableConfigEntity> configVos, String userName) {
        if (CollectionUtil.listNotEmptyNotSizeZero(configVos)) {
            if (StringUtils.isBlank((CharSequence)userName)) {
                configVos.forEach(entity -> this.redisService.hset("TABLE_CONFIG_" + entity.getFunctionId(), entity.getField(), entity));
            } else {
                configVos.forEach(entity -> this.redisService.hset("TABLE_CONFIG_" + userName + "_" + entity.getFunctionId(), entity.getField(), entity));
            }
        }
    }
}

