/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.configure.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.configure.service.KnlFormConfigService;
import com.biz.eisp.configure.entity.KnlFormConfigEntity;
import com.biz.eisp.configure.vo.KnlFormConfigVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/knlFormConfigController"})
public class KnlFormConfigController {
    @Autowired
    private KnlFormConfigService knlFormConfigService;

    @RequestMapping(value={"findKnlFormConfigPage"})
    public DataGrid findKnlFormConfigPage(HttpServletRequest request, KnlFormConfigVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<KnlFormConfigVo> knlFormConfigVoPageInfo = this.knlFormConfigService.findKnlFormConfigPage(vo, (Page)page);
        if (knlFormConfigVoPageInfo != null) {
            return new DataGrid(knlFormConfigVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"saveOrUpdate"})
    public AjaxJson saveOrUpdate(KnlFormConfigVo vo) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getFunctionId())) {
            j.setErrMsg("\u53c2\u6570\u9519\u8bef");
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.knlFormConfigService.update(vo);
            } else {
                this.knlFormConfigService.save(vo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(value={"deleteFormConfig"})
    public AjaxJson deleteFormConfig(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlFormConfigService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"validateFormTags"})
    public ValidForm validateFormTags(HttpServletRequest request, String id) {
        String param = OConvertUtils.getString((String)request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        try {
            KnlFormConfigVo vo = new KnlFormConfigVo();
            vo.setFormTags(param);
            vo.setId(id);
            List<KnlFormConfigEntity> list = this.knlFormConfigService.getKnlFormConfigEntity(vo);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                validForm.setStatus("n");
                validForm.setInfo("\u6807\u7b7e\u5df2\u5b58\u5728");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validForm;
    }
}

