/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.mdm;

import com.biz.eisp.api.feign.CustOrgFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TagUtil;
import com.biz.eisp.custOrg.entity.TmCustomerOrgEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.tree.TreeGrid;
import com.biz.eisp.tree.TreeGridModel;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"mdmCustOrgController"})
public class MdmCustOrgController {
    @Autowired
    private CustOrgFeign custOrgFeign;

    @RequestMapping(value={"findCustOrgList"})
    @ResponseBody
    public DataGrid findCustOrgList(HttpServletRequest request, TmCustomerOrgEntity tmOrgEntity) {
        EuPage page = new EuPage(request);
        PageInfo info = this.custOrgFeign.findCustOrgList(tmOrgEntity, page.getPage(), page.getRows()).getPageInfo();
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findCustOrgTree"})
    @ResponseBody
    public List<TreeGrid> findCustOrgTree(TmCustomerOrgEntity tmOrgEntity) {
        List<TreeGrid> treeGrids = null;
        if (StringUtil.isNotEmpty((CharSequence)tmOrgEntity.getId())) {
            AjaxJson ajaxJson = this.custOrgFeign.getCustOrgList(tmOrgEntity);
            if (ajaxJson != null) {
                for (TmCustomerOrgEntity orgEntity : ajaxJson.getObjList()) {
                    treeGrids = this.treeGridModel(orgEntity.getTmCustOrgs());
                }
            }
        } else {
            AjaxJson ajaxJson = this.custOrgFeign.getCustOrgList(tmOrgEntity);
            if (ajaxJson != null) {
                treeGrids = this.treeGridModel(ajaxJson.getObjList());
            }
        }
        treeGrids.forEach(e -> e.setText(e.getSrc()));
        return treeGrids;
    }

    private List<TreeGrid> treeGridModel(List<TmCustomerOrgEntity> orgList) {
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("custOrgCode");
        treeGridModel.setSrc("customerOrgName");
        treeGridModel.setParentId("parentId");
        treeGridModel.setFunctionType("custOrgType");
        treeGridModel.setIdField("id");
        treeGridModel.setParentText("text");
        treeGridModel.setChildList("tmCustOrgs");
        treeGrids = this.treegrid(orgList, treeGridModel);
        return treeGrids;
    }

    private List<TreeGrid> treegrid(List all, TreeGridModel treeGridModel) {
        ArrayList<TreeGrid> treegrid = new ArrayList<TreeGrid>();
        for (Object obj : all) {
            List childList;
            Object icon;
            ReflectHelper reflectHelper = new ReflectHelper(obj);
            TreeGrid tg = new TreeGrid();
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getCode())) {
                String code = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getCode()));
                tg.setCode(code);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getOrder())) {
                String order = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getOrder()));
                tg.setOrder(order);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getIdField())) {
                String id = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getIdField()));
                tg.setId(id);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getSrc())) {
                String src = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getSrc()));
                tg.setSrc(src);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getTextField())) {
                String text = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getTextField()));
                tg.setText(text);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getParentText())) {
                String orgDesc = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getParentText()));
                tg.setParentText(orgDesc);
            }
            if (treeGridModel.getParentId() != null) {
                Object pid = TagUtil.fieldNametoValues((String)treeGridModel.getParentId(), obj);
                if (pid != null) {
                    tg.setParentId(pid.toString());
                } else {
                    tg.setParentId("");
                }
            }
            if (treeGridModel.getIcon() != null && (icon = TagUtil.fieldNametoValues((String)treeGridModel.getIcon(), obj)) != null) {
                tg.setIcon(icon.toString());
            }
            if ((childList = (List)reflectHelper.getMethodValue(treeGridModel.getChildList())) != null && childList.size() > 0) {
                tg.setState("closed");
            }
            if (treeGridModel.getFieldMap() != null) {
                tg.setFieldMap(new HashMap());
                for (Map.Entry entry : treeGridModel.getFieldMap().entrySet()) {
                    Object fieldValue = reflectHelper.getMethodValue(entry.getValue().toString());
                    tg.getFieldMap().put(entry.getKey(), fieldValue);
                }
            }
            treegrid.add(tg);
        }
        return treegrid;
    }
}

