/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.configure.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.configure.dao.KnlFunConfigPageDao;
import com.biz.eisp.base.configure.service.KnlFunConfigPageService;
import com.biz.eisp.configure.entity.KnlFunConfigPageEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/knlFunConfigController"})
public class KnlFunConfigController {
    @Autowired
    private KnlFunConfigPageService mdmFunConfigPageService;
    @Autowired
    private KnlFunConfigPageDao mdmFunConfigPageDao;

    @RequestMapping(value={"findMdmFunConfigPage"})
    public DataGrid findMdmFunConfigPage(HttpServletRequest request, KnlFunConfigPageEntity vo) {
        EuPage page = new EuPage(request);
        page.setRows("100");
        PageInfo<KnlFunConfigPageEntity> mdmFunConfigPageVoPageInfo = null;
        if (vo != null && StringUtil.isNotBlank((CharSequence)vo.getFunId())) {
            mdmFunConfigPageVoPageInfo = this.mdmFunConfigPageService.findMdmFunConfigPage(vo, (Page)page);
        }
        if (mdmFunConfigPageVoPageInfo != null) {
            return new DataGrid(mdmFunConfigPageVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"getMdmFunConfigPageByParamObj"})
    public AjaxJson<KnlFunConfigPageEntity> getMdmFunConfigPageByParamObj(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            KnlFunConfigPageEntity mdmFunConfigPageEntity = new KnlFunConfigPageEntity();
            mdmFunConfigPageEntity.setId(id);
            KnlFunConfigPageEntity result = (KnlFunConfigPageEntity)this.mdmFunConfigPageDao.selectOne(mdmFunConfigPageEntity);
            if (null != result) {
                ajaxJson.setObj((Object)result);
            }
        }
        return ajaxJson;
    }

    @RequestMapping(value={"addOrUpdate"})
    public AjaxJson addOrUpdate(KnlFunConfigPageEntity mdmFunConfigPageEntity) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtils.isNotBlank((CharSequence)mdmFunConfigPageEntity.getId())) {
            ajaxJson.setSuccess(this.mdmFunConfigPageService.updateEntity(mdmFunConfigPageEntity));
        } else {
            ajaxJson.setSuccess(this.mdmFunConfigPageService.insertEntity(mdmFunConfigPageEntity));
        }
        return ajaxJson;
    }

    @RequestMapping(value={"deleteByIds"})
    public AjaxJson deleteByIds(@RequestParam(value="ids") String ids) {
        String[] idArr;
        AjaxJson ajaxJson = new AjaxJson();
        for (String id : idArr = ids.split(",")) {
            this.mdmFunConfigPageService.deleteByIds(id);
        }
        return ajaxJson;
    }
}

