/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.configure.service.impl;

import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.configure.dao.KnlFormConfigDao;
import com.biz.eisp.base.configure.service.KnlFormConfigService;
import com.biz.eisp.configure.entity.KnlFormConfigEntity;
import com.biz.eisp.configure.vo.KnlFormConfigVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="knlFormConfigService")
@Transactional
public class KnlFormConfigServiceImplImpl
extends BaseServiceImpl<KnlFormConfigEntity>
implements KnlFormConfigService {
    @Autowired
    private KnlFormConfigDao knlFormConfigDao;
    @Autowired
    private RedisService redisService;

    @Override
    public List<KnlFormConfigVo> findKnlFormConfigList(KnlFormConfigVo vo) {
        return this.knlFormConfigDao.findKnlFormConfigList(vo);
    }

    @Override
    public PageInfo<KnlFormConfigVo> findKnlFormConfigPage(KnlFormConfigVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.knlFormConfigDao.findKnlFormConfigList(vo), (Page)page);
    }

    @Override
    public KnlFormConfigEntity getKnlFormConfigEntity(String id) {
        return (KnlFormConfigEntity)this.knlFormConfigDao.selectByPrimaryKey(id);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=KnlFormConfigServiceImplImpl.class)
    public void save(KnlFormConfigVo vo) throws Exception {
        KnlFormConfigEntity entity = new KnlFormConfigEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.insertSelective(entity);
        }
        this.redisService.hset("FORM_CONFIG_" + entity.getFunctionId(), entity.getFieldCode(), (Object)entity);
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=KnlFormConfigServiceImplImpl.class)
    public void update(KnlFormConfigVo vo) throws Exception {
        KnlFormConfigEntity entity = new KnlFormConfigEntity();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (KnlFormConfigEntity)this.knlFormConfigDao.selectByPrimaryKey(vo.getId());
            vo.setCreateBy(entity.getCreateBy());
            vo.setCreateDate(entity.getCreateDate());
            vo.setCreateName(entity.getCreateName());
            vo.setPositionCode(entity.getPositionCode());
            vo.setPositionName(entity.getPositionName());
            BeanUtils.copyProperties((Object)vo, (Object)entity);
            this.updateByPrimaryKey(entity);
        }
        this.redisService.hset("FORM_CONFIG_" + entity.getFunctionId(), entity.getFieldCode(), (Object)entity);
    }

    @Override
    public List<KnlFormConfigEntity> getKnlFormConfigEntity(KnlFormConfigVo vo) throws Exception {
        Example inexample = new Example(KnlFormConfigEntity.class);
        Example.Criteria criteria = inexample.createCriteria();
        criteria.andEqualTo("formTags", (Object)vo.getFormTags());
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            criteria.andNotEqualTo("id", (Object)vo.getId());
        }
        return this.knlFormConfigDao.selectByExample(inexample);
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=KnlFormConfigServiceImplImpl.class)
    public boolean delete(String id) {
        KnlFormConfigEntity formEntity = (KnlFormConfigEntity)this.knlFormConfigDao.selectByPrimaryKey(id);
        String functionId = formEntity.getFunctionId();
        String fileCode = formEntity.getFieldCode();
        int i = this.knlFormConfigDao.deleteByPrimaryKey(id);
        if (i > 0) {
            this.redisService.hdel("FORM_CONFIG_" + functionId, new Object[]{fileCode});
            return true;
        }
        return false;
    }
}

