/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.dict.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.tag.params.DictEnum;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.dict.dao.KnlDictDataDao;
import com.biz.eisp.base.dict.dao.KnlDictExtendDao;
import com.biz.eisp.base.dict.service.KnlDictDataService;
import com.biz.eisp.base.utils.SqlInUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.dict.entity.KnlDictExtendsEntitiy;
import com.biz.eisp.dict.vo.KnlDictDataVo;
import com.biz.eisp.dict.vo.KnlDictExtendsVo;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.util.EnableModifyLog;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="knlDictDataService")
@Transactional
public class KnlDictDataServiceImplImpl
extends BaseServiceImpl<KnlDictDataEntity>
implements KnlDictDataService {
    @Autowired
    private KnlDictDataDao knlDictDataDao;
    @Autowired
    private KnlDictExtendDao knlDictExtendDao;
    @Autowired
    private RedisService redisService;
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String ID = "id";
    private static final String JSONFORM = "jsonForm";
    private static final String DICTTYPECODE = "dictTypeCode";

    @Override
    public JSONArray findKnlDictDataList(KnlDictDataVo vo) {
        List<Object> list = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            vo.setParentId(vo.getId());
            vo.setDictTypeCode(null);
        }
        list = this.knlDictDataDao.findKnlDictDataList(vo);
        JSONArray array = new JSONArray();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            ArrayList ins = new ArrayList();
            list.forEach(item -> ins.add(item.getId()));
            List includs = new SqlInUtils().getSqlList(ins);
            List<KnlDictExtendsVo> extendsVos = this.knlDictExtendDao.findKnlDictExtendsListByIds(includs);
            if (CollectionUtil.listNotEmptyNotSizeZero(extendsVos)) {
                Map<String, List<KnlDictExtendsVo>> map = extendsVos.stream().collect(Collectors.groupingBy(KnlDictExtendsVo::getDictDataId));
                map.forEach((k, v) -> {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put(ID, k);
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)v)) {
                        v.stream().forEach(item -> {
                            if (item.getFieldCode().equals(DictEnum.tcode.getVal())) {
                                jsonObject.put("text", (Object)item.getExtendValue());
                            } else {
                                jsonObject.put(item.getFieldCode(), (Object)item.getExtendValue());
                            }
                        });
                    }
                    KnlDictDataEntity entitiy = new KnlDictDataEntity();
                    entitiy.setParentId(k);
                    int count = this.knlDictDataDao.selectCount(entitiy);
                    if (count > 0) {
                        jsonObject.put("state", (Object)"closed");
                    } else {
                        jsonObject.put("state", (Object)"open");
                        jsonObject.put("parentId", (Object)vo.getId());
                    }
                    if (!jsonObject.containsKey((Object)"orderNum") || StringUtils.isBlank((CharSequence)jsonObject.getString("orderNum"))) {
                        jsonObject.put("orderNum", (Object)"1");
                    }
                    array.add((Object)jsonObject);
                });
            }
        }
        array.sort(Comparator.comparing(obj -> ((JSONObject)obj).getInteger("orderNum")));
        return array;
    }

    @Override
    public boolean delete(String id) {
        KnlDictDataEntity entity = (KnlDictDataEntity)this.knlDictDataDao.selectByPrimaryKey(id);
        int i = this.knlDictDataDao.deleteByPrimaryKey(id);
        if (i > 0) {
            this.redisService.del(new String[]{"DICT_DATA_" + entity.getDictTypeCode()});
            Example inexample = new Example(KnlDictExtendsEntitiy.class);
            Example.Criteria criteria = inexample.createCriteria();
            criteria.andEqualTo("dictDataId", (Object)id);
            this.knlDictExtendDao.deleteByExample(inexample);
            return true;
        }
        return false;
    }

    @Override
    public KnlDictDataEntity getDictDataById(String id) {
        KnlDictDataEntity entity = (KnlDictDataEntity)this.knlDictDataDao.selectByPrimaryKey(id);
        KnlDictDataEntity entity_ = (KnlDictDataEntity)this.redisService.hget("DICT_DATA_" + entity.getDictTypeCode(), entity.getDictCode());
        if (entity_ == null) {
            entity_ = this.dealData(entity);
        }
        return entity_;
    }

    private KnlDictDataEntity dealData(KnlDictDataEntity entity) {
        HashMap<String, String> extendMap = new HashMap<String, String>();
        Example example = new Example(KnlDictExtendsEntitiy.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("dictDataId", (Object)entity.getId());
        List extendsEntitiys = this.knlDictExtendDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)extendsEntitiys)) {
            for (KnlDictExtendsEntitiy item : extendsEntitiys) {
                extendMap.put(item.getFieldCode(), item.getExtendValue() == null ? "" : item.getExtendValue());
            }
        }
        entity.setExtendMap(extendMap);
        this.redisService.hset("DICT_DATA_" + entity.getDictTypeCode(), entity.getDictCode(), (Object)entity);
        return entity;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=KnlDictDataServiceImplImpl.class)
    public void save(KnlDictDataVo vo) throws Exception {
        KnlDictDataEntity entity = new KnlDictDataEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.knlDictDataDao.insertSelective(entity);
        }
        JSONArray array = JSONArray.parseArray((String)vo.getJsonForm());
        HashMap<String, String> extendMap = new HashMap<String, String>();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            String name = jsonObject.getString(NAME);
            String value = jsonObject.getString(VALUE);
            if (ID.equals(name) || JSONFORM.equals(name) || DICTTYPECODE.equals(name)) continue;
            KnlDictExtendsEntitiy extendsEntitity = new KnlDictExtendsEntitiy();
            extendsEntitity.setDictDataId(entity.getId());
            extendsEntitity.setFieldCode(name);
            extendsEntitity.setExtendValue(value);
            extendMap.put(name, value);
            this.knlDictExtendDao.insertSelective(extendsEntitity);
        }
        entity.setExtendMap(extendMap);
        this.redisService.del(new String[]{"DICT_DATA_" + entity.getDictTypeCode()});
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=KnlDictDataServiceImplImpl.class)
    public void update(KnlDictDataVo vo) throws Exception {
        KnlDictDataEntity entity = new KnlDictDataEntity();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (KnlDictDataEntity)this.knlDictDataDao.selectByPrimaryKey(vo.getId());
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.knlDictDataDao.updateByPrimaryKeySelective(entity);
            Example inexample = new Example(KnlDictExtendsEntitiy.class);
            Example.Criteria criteria = inexample.createCriteria();
            criteria.andEqualTo("dictDataId", (Object)vo.getId());
            this.knlDictExtendDao.deleteByExample(inexample);
            if (StringUtils.isNotBlank((CharSequence)entity.getParentId())) {
                this.redisService.del(new String[]{entity.getParentId()});
            }
        }
        JSONArray array = JSONArray.parseArray((String)vo.getJsonForm());
        HashMap<String, String> extendMap = new HashMap<String, String>();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            String name = jsonObject.getString(NAME);
            String value = jsonObject.getString(VALUE);
            if (ID.equals(name) || JSONFORM.equals(name) || DICTTYPECODE.equals(name)) continue;
            KnlDictExtendsEntitiy extendsEntitity = new KnlDictExtendsEntitiy();
            extendsEntitity.setDictDataId(entity.getId());
            extendsEntitity.setFieldCode(name);
            extendsEntitity.setExtendValue(value);
            extendMap.put(name, value);
            this.knlDictExtendDao.insertSelective(extendsEntitity);
        }
        entity.setExtendMap(extendMap);
        this.redisService.del(new String[]{"DICT_DATA_" + entity.getDictTypeCode()});
    }
}

