/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.notice.service.impl;

import com.biz.eisp.base.attachment.service.KnlAttachmentService;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.notice.dao.KnlNoticeDao;
import com.biz.eisp.base.notice.service.KnlNoticeService;
import com.biz.eisp.notice.entity.KnlNoticeEntity;
import com.biz.eisp.notice.vo.KnlNoticeVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="knlNoticeService")
@Transactional
public class KnlNoticeServiceImplImpl
extends BaseServiceImpl<KnlNoticeEntity>
implements KnlNoticeService {
    @Autowired
    private KnlNoticeDao knlNoticeDao;
    @Autowired
    private KnlAttachmentService knlAttachmentService;

    @Override
    public List<KnlNoticeVo> findKnlNoticeList(@Param(value="vo") KnlNoticeVo vo) {
        return this.knlNoticeDao.findKnlNoticeList(vo);
    }

    @Override
    public PageInfo<KnlNoticeVo> findKnlNoticePage(KnlNoticeVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.knlNoticeDao.findKnlNoticeList(vo), (Page)page);
    }

    @Override
    public KnlNoticeEntity getKnlNoticeEntity(String id) {
        return (KnlNoticeEntity)this.knlNoticeDao.selectByPrimaryKey(id);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=KnlNoticeServiceImplImpl.class)
    public void save(KnlNoticeVo vo) throws Exception {
        KnlNoticeEntity entity = new KnlNoticeEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.insertSelective(entity);
            this.knlAttachmentService.saveFiles(vo.getFileJson(), entity.getId());
        }
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=KnlNoticeServiceImplImpl.class)
    public void update(KnlNoticeVo vo) throws Exception {
        KnlNoticeEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (KnlNoticeEntity)this.knlNoticeDao.selectByPrimaryKey(vo.getId());
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.updateByPrimaryKeySelective(entity);
            this.knlAttachmentService.saveFiles(vo.getFileJson(), vo.getId());
        }
    }

    @Override
    public List<KnlNoticeEntity> getKnlNoticeEntityList(KnlNoticeVo vo) throws Exception {
        Example inexample = new Example(KnlNoticeEntity.class);
        Example.Criteria criteria = inexample.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            criteria.andNotEqualTo("id", (Object)vo.getId());
        }
        return this.knlNoticeDao.selectByExample(inexample);
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=KnlNoticeServiceImplImpl.class)
    public boolean delete(String id) {
        int i = this.knlNoticeDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public PageInfo<KnlNoticeEntity> getKnlNoticePage(Map<String, Object> param, Page page) {
        Example example = new Example(KnlNoticeEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((Object)param.get("noticeTitle"))) {
            criteria.andLike("noticeTitle", "%" + param.get("noticeTitle").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("receivingOrgCode"))) {
            criteria.andLike("receivingOrgCode", "%" + param.get("receivingOrgCode").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("receivingOrgName"))) {
            criteria.andLike("receivingOrgName", "%" + param.get("receivingOrgName").toString() + "%");
        }
        return PageAutoHelperUtil.generatePage(() -> this.knlNoticeDao.selectByExample(example), (Page)page);
    }
}

