/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.timeTask.controller;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.timeTask.service.ScheduleJobService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.timeJob.entity.SchedulejobEntity;
import com.github.pagehelper.PageInfo;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scheduleJob"})
public class ScheduleJobController {
    @Autowired
    private ScheduleJobService service;

    @RequestMapping(value={"findTaskList"})
    public DataGrid findTaskList(HttpServletRequest request, SchedulejobEntity o) {
        EuPage page = new EuPage(request);
        PageInfo<SchedulejobEntity> pageInfo = this.service.findTaskPage(o, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"find"})
    public AjaxJson find(SchedulejobEntity o) {
        AjaxJson ar = new AjaxJson();
        try {
            PageInfo<SchedulejobEntity> pageInfo = this.service.findTaskPage(o, null);
            SchedulejobEntity obj = (SchedulejobEntity)pageInfo.getList().get(0);
            ar.setObj((Object)obj);
        }
        catch (Exception e) {
            ar.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ar;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    public AjaxJson save(SchedulejobEntity o) {
        AjaxJson ar = new AjaxJson();
        try {
            if (o != null && StringUtils.isNotBlank((String)o.getId())) {
                int res = this.service.updateScheduleJob(o);
                if (res == 1) {
                    ar.setMsg("\u66f4\u65b0\u6210\u529f");
                } else {
                    ar.setMsg("\u66f4\u65b0\u5931\u8d25");
                }
            } else {
                int res = this.service.creatScheduleJob(o);
                if (res == 1) {
                    ar.setMsg("\u65b0\u589e\u6210\u529f");
                } else {
                    ar.setMsg("\u65b0\u589e\u5931\u8d25");
                    ar.setSuccess(false);
                }
            }
        }
        catch (Exception e) {
            ar.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ar;
    }

    @RequestMapping(value={"del"}, method={RequestMethod.POST})
    public AjaxJson del(SchedulejobEntity o) {
        AjaxJson ar = new AjaxJson();
        try {
            int res = this.service.deleteScheduleJob(o);
            if (res == 1) {
                ar.setMsg("\u5220\u9664\u6210\u529f");
            } else {
                ar.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            ar.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return ar;
    }

    @RequestMapping(value={"runOnce"}, method={RequestMethod.POST})
    public AjaxJson runOnce(SchedulejobEntity o) {
        AjaxJson ar = new AjaxJson();
        try {
            int res = this.service.runOnce(o);
            if (res == 1) {
                ar.setMsg("\u8fd0\u884c\u6210\u529f");
            } else if (res == 2) {
                ar.setMsg("\u8bf7\u5148\u505c\u7528\u4efb\u52a1");
            } else {
                ar.setMsg("\u8fd0\u884c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            ar.setMsg("\u8fd0\u884c\u5931\u8d25");
        }
        return ar;
    }

    @RequestMapping(value={"resumeJob"}, method={RequestMethod.POST})
    public AjaxJson resumeJob(SchedulejobEntity o) {
        AjaxJson ar = new AjaxJson();
        try {
            int res = this.service.resumeJob(o);
            if (res == 1) {
                ar.setMsg("\u542f\u52a8\u6210\u529f");
            } else if (res == 2) {
                ar.setMsg("\u9879\u76ee\u5df2\u542f\u52a8");
            } else {
                ar.setMsg("\u542f\u52a8\u5931\u8d25");
            }
        }
        catch (BusinessException e) {
            ar.setMsg(e.getMessage());
            ar.setSuccess(false);
        }
        catch (Exception e) {
            ar.setMsg("\u542f\u52a8\u5931\u8d25");
            ar.setSuccess(false);
        }
        return ar;
    }

    @RequestMapping(value={"pauseJob"}, method={RequestMethod.POST})
    public AjaxJson pauseJob(SchedulejobEntity o) {
        AjaxJson ar = new AjaxJson();
        try {
            int res = this.service.pauseJob(o);
            if (res == 1) {
                ar.setMsg("\u6682\u505c\u6210\u529f");
            } else if (res == 2) {
                ar.setMsg("\u9879\u76ee\u6ca1\u542f\u52a8\uff0c\u4e0d\u7528\u6682\u505c");
            } else {
                ar.setMsg("\u6682\u505c\u5931\u8d25");
            }
        }
        catch (BusinessException e) {
            ar.setMsg(e.getMessage());
        }
        catch (Exception e) {
            ar.setMsg("\u6682\u505c\u5931\u8d25");
        }
        return ar;
    }

    @GetMapping(value={"getSchedulejobEntity"})
    public AjaxJson<SchedulejobEntity> getSchedulejobEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        SchedulejobEntity entity = this.service.getSchedulejobEntity(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }
}

