/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.dict.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.dict.dao.KnlDictDataDao;
import com.biz.eisp.base.dict.dao.KnlDictTypeDao;
import com.biz.eisp.base.dict.service.KnlDictTypeService;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.dict.entity.KnlDictTypeEntity;
import com.biz.eisp.dict.vo.KnlDictTypeVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="knlDictTypeService")
@Transactional
public class KnlDictTypeServiceImplImpl
extends BaseServiceImpl<KnlDictTypeEntity>
implements KnlDictTypeService {
    @Autowired
    private KnlDictTypeDao knlDictTypeDao;
    @Autowired
    private KnlDictDataDao knlDictDataDao;
    @Autowired
    private RedisService redisService;

    @Override
    public PageInfo<KnlDictTypeVo> findKnlDictTypePage(KnlDictTypeVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.knlDictTypeDao.findKnlDictTypeList(vo), (Page)page);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=KnlDictTypeServiceImplImpl.class)
    public boolean save(KnlDictTypeVo vo) throws Exception {
        KnlDictTypeEntity typeEntity = new KnlDictTypeEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)typeEntity);
            this.knlDictTypeDao.insertSelective(typeEntity);
        }
        this.redisService.del(new String[]{"DICT_TYPE_"});
        return false;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=KnlDictTypeServiceImplImpl.class)
    public boolean update(KnlDictTypeVo vo) throws Exception {
        KnlDictTypeEntity typeEntity = new KnlDictTypeEntity();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            typeEntity = (KnlDictTypeEntity)this.knlDictTypeDao.selectByPrimaryKey(vo.getId());
            if (StringUtils.isNotBlank((CharSequence)vo.getDictTypeCode()) && StringUtils.isNotBlank((CharSequence)typeEntity.getDictTypeCode()) && !typeEntity.getDictTypeCode().equals(vo.getDictTypeCode())) {
                Example example = new Example(KnlDictDataEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("dictTypeCode", (Object)typeEntity.getDictTypeCode());
                List datas = this.knlDictDataDao.selectByExample(example);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)datas)) {
                    datas.forEach(item -> item.setDictTypeCode(vo.getDictTypeCode()));
                    this.knlDictDataDao.updateBatchByPrimaryKeySelective(datas);
                    this.redisService.del(new String[]{"DICT_DATA_" + typeEntity.getDictTypeCode()});
                }
            }
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)typeEntity);
            this.knlDictTypeDao.updateByPrimaryKeySelective(typeEntity);
        }
        this.redisService.del(new String[]{"DICT_TYPE_"});
        return false;
    }

    @Override
    public KnlDictTypeEntity getKnlDictTypeEntity(String id) {
        return (KnlDictTypeEntity)this.knlDictTypeDao.selectByPrimaryKey(id);
    }

    @Override
    public List<KnlDictTypeEntity> getKnlDictTypeEntity(KnlDictTypeVo vo) throws Exception {
        Example inexample = new Example(KnlDictTypeEntity.class);
        Example.Criteria criteria = inexample.createCriteria();
        criteria.andEqualTo("dictTypeCode", (Object)vo.getDictTypeCode());
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            criteria.andNotEqualTo("id", (Object)vo.getId());
        }
        return this.knlDictTypeDao.selectByExample(inexample);
    }

    @Override
    public boolean delete(String id) {
        KnlDictTypeEntity typeEntity = (KnlDictTypeEntity)this.knlDictTypeDao.selectByPrimaryKey(id);
        int i = this.knlDictTypeDao.deleteByPrimaryKey(id);
        if (i > 0) {
            this.redisService.del(new String[]{"DICT_TYPE_"});
            return true;
        }
        return false;
    }
}

