/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.code.service.impl;

import com.biz.eisp.base.code.dao.KnlCodingRulesDao;
import com.biz.eisp.base.code.service.KnlCodingRulesService;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.code.entity.KnlCodingRulesEntity;
import com.biz.eisp.code.vo.KnlCodingRulesVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="knlCodingRulesService")
@Transactional
public class KnlCodingRulesServiceImplImpl
extends BaseServiceImpl<KnlCodingRulesEntity>
implements KnlCodingRulesService {
    @Autowired
    private KnlCodingRulesDao knlCodingRulesDao;
    @Autowired
    private RedisService redisService;

    @Override
    public List<KnlCodingRulesVo> findKnlCodingRulesList(KnlCodingRulesVo vo) {
        return this.knlCodingRulesDao.findKnlCodingRulesList(vo);
    }

    @Override
    public PageInfo<KnlCodingRulesVo> findKnlCodingRulesPage(KnlCodingRulesVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.knlCodingRulesDao.findKnlCodingRulesList(vo), (Page)page);
    }

    @Override
    public KnlCodingRulesEntity getKnlCodingRulesEntity(String id) {
        return (KnlCodingRulesEntity)this.knlCodingRulesDao.selectByPrimaryKey(id);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=KnlCodingRulesServiceImplImpl.class)
    public void save(KnlCodingRulesVo vo) throws Exception {
        KnlCodingRulesEntity entity = new KnlCodingRulesEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.insertSelective(entity);
        }
        this.redisService.setDays("CODE_RULE_" + entity.getCodingRuleCode(), (Object)entity, 3650L);
        this.redisService.incr("CODE_RULE_INIT_" + entity.getCodingRuleCode(), (long)Integer.valueOf(entity.getInitialValue()).intValue());
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=KnlCodingRulesServiceImplImpl.class)
    public void update(KnlCodingRulesVo vo) throws Exception {
        KnlCodingRulesEntity entity = new KnlCodingRulesEntity();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (KnlCodingRulesEntity)this.knlCodingRulesDao.selectByPrimaryKey(vo.getId());
            entity.setCurrentValue(vo.getCurrentValue() == null ? entity.getCurrentValue() : vo.getCurrentValue());
            entity.setCodeLength(vo.getCodeLength());
            entity.setCodingRuleCode(vo.getCodingRuleCode());
            entity.setDateStr(vo.getDateStr());
            entity.setInitialValue(vo.getInitialValue());
            entity.setPrefix(vo.getPrefix());
            entity.setRuleDescription(vo.getRuleDescription());
            this.updateByPrimaryKeySelective(entity);
        }
        this.redisService.setDays("CODE_RULE_" + entity.getCodingRuleCode(), (Object)entity, 3650L);
        this.redisService.incr("CODE_RULE_INIT_" + entity.getCodingRuleCode(), (long)Integer.valueOf(entity.getInitialValue()).intValue());
    }

    @Override
    public List<KnlCodingRulesEntity> getKnlCodingRulesEntity(KnlCodingRulesVo vo) {
        Example inexample = new Example(KnlCodingRulesEntity.class);
        Example.Criteria criteria = inexample.createCriteria();
        criteria.andEqualTo("codingRuleCode", (Object)vo.getCodingRuleCode());
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            criteria.andNotEqualTo("id", (Object)vo.getId());
        }
        return this.knlCodingRulesDao.selectByExample(inexample);
    }

    @Override
    public boolean updateCodeRuleByCode(KnlCodingRulesVo vo) {
        return this.knlCodingRulesDao.updateCodeRuleByCode(vo);
    }

    @Override
    public boolean resetCurrentValue(KnlCodingRulesVo vo) {
        KnlCodingRulesEntity entity = new KnlCodingRulesEntity();
        entity.setId(vo.getId());
        entity.setCurrentValue(Integer.valueOf(0));
        int i = this.knlCodingRulesDao.updateByPrimaryKeySelective(entity);
        return i > 0;
    }
}

