/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.attachment.controller;

import com.biz.eisp.attachment.entity.KnlAttachmentEntity;
import com.biz.eisp.attachment.vo.KnlAttachmentVo;
import com.biz.eisp.base.attachment.service.KnlAttachmentService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/knlAttachmentController"})
public class KnlAttachmentController {
    private static final Logger log = LoggerFactory.getLogger(KnlAttachmentController.class);
    @Autowired
    private KnlAttachmentService knlAttachmentService;

    @RequestMapping(value={"uploadKnlAttachment"})
    @ResponseBody
    public AjaxJson uploadKnlAttachment(String fileJson, String businessKey) {
        AjaxJson j = new AjaxJson();
        this.knlAttachmentService.saveFiles(fileJson, businessKey);
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"deletefile"})
    public AjaxJson deletefile(String id) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlAttachmentService.delete(id)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @PostMapping(value={"getKnlAttachmentList"})
    public AjaxJson<KnlAttachmentEntity> getKnlAttachmentList(@RequestBody KnlAttachmentVo attachmentVo) {
        AjaxJson ajaxJson = new AjaxJson();
        List<KnlAttachmentEntity> knlAttachmentEntities = this.knlAttachmentService.getKnlAttachmentList(attachmentVo);
        ajaxJson.setList(knlAttachmentEntities);
        return ajaxJson;
    }

    @RequestMapping(value={"findAttachmentList"})
    public DataGrid findAttachmentList(String businessKey, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo<KnlAttachmentEntity> list = this.knlAttachmentService.findAttachmentList(businessKey, (Page)page);
        return new DataGrid(list);
    }
}

