/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.code.controller;

import com.biz.eisp.base.code.service.KnlCodingRulesService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.RedisUtils;
import com.biz.eisp.code.entity.KnlCodingRulesEntity;
import com.biz.eisp.code.vo.KnlCodingRulesVo;
import com.biz.eisp.kernel.KnlCodeRuleFeign;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.service.RedisService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/knlCodingRulesController"})
public class KnlCodingRulesController {
    private static final Logger log = LoggerFactory.getLogger(KnlCodingRulesController.class);
    @Autowired
    private KnlCodingRulesService knlCodingRulesService;
    @Autowired
    private static RedisService redisService;
    @Autowired
    private KnlCodeRuleFeign knlCodeRuleFeign;

    private static void getRedisService() {
        if (redisService == null) {
            redisService = RedisUtils.getRedisService();
        }
    }

    @RequestMapping(value={"goKnlCodingRulesMain"})
    public ModelAndView goKnlCodingRulesMain() {
        return new ModelAndView("com/biz/eisp/code/codingRulesMain");
    }

    @RequestMapping(value={"findKnlCodingRulesPage"})
    @ResponseBody
    public DataGrid findKnlCodingRulesPage(HttpServletRequest request, KnlCodingRulesVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<KnlCodingRulesVo> knlCodingRulesVoPageInfo = this.knlCodingRulesService.findKnlCodingRulesPage(vo, (Page)page);
        if (knlCodingRulesVoPageInfo != null) {
            return new DataGrid(knlCodingRulesVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"goSaveOrUpdateCodingRules"})
    public ModelAndView goSaveOrUpdateCodingRules(HttpServletRequest request, KnlCodingRulesVo vo) {
        if (vo != null && StringUtils.isNotBlank((CharSequence)vo.getId())) {
            KnlCodingRulesEntity entity = this.knlCodingRulesService.getKnlCodingRulesEntity(vo.getId());
            request.setAttribute("vo", (Object)entity);
        }
        return new ModelAndView("com/biz/eisp/code/codingRulesForm");
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(KnlCodingRulesVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.knlCodingRulesService.update(vo);
            } else {
                KnlCodingRulesVo knlCodingRulesVo = new KnlCodingRulesVo();
                knlCodingRulesVo.setCodingRuleCode(vo.getCodingRuleCode());
                List<KnlCodingRulesEntity> list = this.knlCodingRulesService.getKnlCodingRulesEntity(knlCodingRulesVo);
                if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                    j.setMsg("\u4e1a\u52a1key\u5df2\u5b58\u5728\uff01");
                    j.setSuccess(false);
                    return j;
                }
                this.knlCodingRulesService.save(vo);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(value={"validateCodingRuleCode"})
    @ResponseBody
    public ValidForm validateCodingRuleCode(HttpServletRequest request, String id) {
        String param = OConvertUtils.getString((String)request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        try {
            KnlCodingRulesVo vo = new KnlCodingRulesVo();
            vo.setCodingRuleCode(param);
            vo.setId(id);
            List<KnlCodingRulesEntity> list = this.knlCodingRulesService.getKnlCodingRulesEntity(vo);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                validForm.setStatus("n");
                validForm.setInfo("\u4e1a\u52a1key\u5df2\u5b58\u5728");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return validForm;
    }

    @ResponseBody
    @RequestMapping(value={"resetCurrentValue"})
    public AjaxJson resetCurrentValue(KnlCodingRulesVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlCodingRulesService.resetCurrentValue(vo)) {
                j.setSuccess(false);
                j.setMsg("\u91cd\u7f6e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u91cd\u7f6e\u5931\u8d25");
        }
        return j;
    }
}

