/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.configure.service.impl;

import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.configure.dao.KnlFunConfigPageDao;
import com.biz.eisp.base.configure.service.KnlFunConfigPageService;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.configure.entity.KnlFunConfigPageEntity;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class KnlFunConfigPageServiceImpl
implements KnlFunConfigPageService {
    private static final Logger log = LoggerFactory.getLogger(KnlFunConfigPageServiceImpl.class);
    @Autowired
    private KnlFunConfigPageDao knlFunConfigPageDao;

    @Override
    public PageInfo<KnlFunConfigPageEntity> findMdmFunConfigPage(KnlFunConfigPageEntity vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.knlFunConfigPageDao.findMdmFunConfigPage(vo), (Page)page);
    }

    @Override
    public boolean insertEntity(KnlFunConfigPageEntity mdmFunConfigPageEntity) {
        boolean flag = true;
        try {
            mdmFunConfigPageEntity.setCreateDate(DateUtils.dateNowStrHms());
            mdmFunConfigPageEntity.setCreateBy(UserUtils.getUser().getRealname());
            this.knlFunConfigPageDao.insert(mdmFunConfigPageEntity);
        }
        catch (Exception e) {
            flag = false;
            log.error("", (Throwable)e);
        }
        return flag;
    }

    @Override
    public boolean updateEntity(KnlFunConfigPageEntity mdmFunConfigPageEntity) {
        boolean flag = true;
        try {
            mdmFunConfigPageEntity.setUpdateDate(DateUtils.dateNowStrHms());
            mdmFunConfigPageEntity.setUpdateBy(UserUtils.getUser().getRealname());
            ArrayList mdmFunConfigPageEntities = Lists.newArrayList();
            mdmFunConfigPageEntities.add(mdmFunConfigPageEntity);
            this.knlFunConfigPageDao.updateBatchByPrimaryKeySelective(mdmFunConfigPageEntities);
        }
        catch (Exception e) {
            flag = false;
            log.error("", (Throwable)e);
        }
        return flag;
    }

    @Override
    public boolean deleteByIds(String id) {
        int i = this.knlFunConfigPageDao.deleteByPrimaryKey(id);
        return i > 0;
    }
}

