/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.dict.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.dict.service.KnlDictConfService;
import com.biz.eisp.base.dict.service.KnlDictTypeService;
import com.biz.eisp.dict.entity.KnlDictAttributeConfEntity;
import com.biz.eisp.dict.entity.KnlDictTypeEntity;
import com.biz.eisp.dict.vo.KnlDictAttributeConfVo;
import com.biz.eisp.dict.vo.KnlDictTypeVo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/knlDictConfController"})
public class KnlDictConfController {
    private static final Logger log = LoggerFactory.getLogger(KnlDictConfController.class);
    @Autowired
    private KnlDictConfService knlDictConfService;
    @Autowired
    private KnlDictTypeService knlDictTypeService;

    @RequestMapping(value={"findKnlDictConfList"})
    public DataGrid findKnlDictConfList(HttpServletRequest request, KnlDictAttributeConfVo vo) {
        List<KnlDictAttributeConfVo> list = this.knlDictConfService.findKnlDictAttributeConfVoList(vo);
        if (CollectionUtil.listEmpty(list)) {
            list = new ArrayList<KnlDictAttributeConfVo>();
        }
        return new DataGrid(list);
    }

    @RequestMapping(value={"saveOrUpdate"})
    public AjaxJson saveOrUpdate(KnlDictAttributeConfVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.knlDictConfService.update(vo);
            } else {
                this.knlDictConfService.save(vo);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(value={"delete"})
    public AjaxJson delete(String id) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlDictConfService.delete(id)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"validateConfCode"})
    public ValidForm validateConfCode(HttpServletRequest request, String id) {
        String param = OConvertUtils.getString((String)request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        try {
            KnlDictTypeVo vo = new KnlDictTypeVo();
            vo.setDictTypeCode(param);
            vo.setId(id);
            List<KnlDictTypeEntity> list = this.knlDictTypeService.getKnlDictTypeEntity(vo);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                validForm.setStatus("n");
                validForm.setInfo("\u6570\u636e\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return validForm;
    }

    @GetMapping(value={"getConfById"})
    public AjaxJson<KnlDictAttributeConfEntity> getConfById(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlDictAttributeConfEntity entity = this.knlDictConfService.getConfById(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }
}

