/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.exception.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.dict.service.KnlDictDataService;
import com.biz.eisp.base.exception.service.KnlExceptionService;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.exception.entity.KnlExceptionEntity;
import com.biz.eisp.exception.vo.ExceptionChartVo;
import com.biz.eisp.exception.vo.ExceptionMonitorVo;
import com.biz.eisp.exception.vo.KnlExceptionVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"/knlExceptionController"})
public class KnlExceptionController {
    private static final Logger log = LoggerFactory.getLogger(KnlExceptionController.class);
    @Autowired
    private KnlExceptionService knlExceptionService;
    @Autowired
    private KnlDictDataService knlDictDataService;

    @RequestMapping(value={"getExceptionRecord"})
    public AjaxJson getExceptionRecord(KnlExceptionVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        List<KnlExceptionVo> knlExceptionVos = this.knlExceptionService.getKnlExceptionLine(vo);
        ExceptionMonitorVo exceptionMonitorVo = new ExceptionMonitorVo();
        int size = knlExceptionVos.size();
        Object[] timeArray = new Object[size];
        Object[] countArray = new Object[size];
        for (int i = 0; i < size; ++i) {
            if (StringUtil.isNotEmpty((CharSequence)knlExceptionVos.get(i).getCreateDateStr())) {
                timeArray[i] = knlExceptionVos.get(i).getCreateDateStr().substring(5, 10);
            }
            if (!StringUtil.isNotEmpty((CharSequence)knlExceptionVos.get(i).getCount())) continue;
            countArray[i] = knlExceptionVos.get(i).getCount();
        }
        exceptionMonitorVo.setCountArray(countArray);
        exceptionMonitorVo.setTimeArray(timeArray);
        Example example = new Example(KnlDictDataEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("dictTypeCode", (Object)"sys_modular");
        List list = this.knlDictDataService.selectExample(example);
        int sizeCake = list.size();
        Object[] exceptionChartVoArray = new Object[sizeCake];
        for (int i = 0; i < sizeCake; ++i) {
            ExceptionChartVo exceptionChartVo = new ExceptionChartVo();
            KnlExceptionVo knlExceptionVo = new KnlExceptionVo();
            knlExceptionVo.setApplicationName(((KnlDictDataEntity)list.get(i)).getDictValue());
            List<KnlExceptionEntity> knlExceptionEntities = this.knlExceptionService.findKnlExceptionList(knlExceptionVo);
            exceptionChartVo.setName(((KnlDictDataEntity)list.get(i)).getDictValue());
            exceptionChartVo.setValue(String.valueOf(knlExceptionEntities.size()));
            exceptionChartVoArray[i] = exceptionChartVo;
        }
        exceptionMonitorVo.setExceptionChartVoArray(exceptionChartVoArray);
        ajaxJson.setObj((Object)exceptionMonitorVo);
        return ajaxJson;
    }

    @RequestMapping(value={"findKnlExceptionPage"})
    public DataGrid findKnlExceptionPage(HttpServletRequest request, KnlExceptionVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<KnlExceptionVo> knlExceptionVoPageInfo = this.knlExceptionService.findKnlExceptionPage(vo, (Page)page);
        if (knlExceptionVoPageInfo != null) {
            return new DataGrid(knlExceptionVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"saveOrUpdate"})
    public AjaxJson saveOrUpdate(KnlExceptionVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.knlExceptionService.update(vo);
            } else {
                this.knlExceptionService.save(vo);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }

    @RequestMapping(value={"deleteException"})
    public AjaxJson deleteException(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlExceptionService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"processException"})
    public AjaxJson processException(KnlExceptionVo vo) {
        AjaxJson json = new AjaxJson();
        try {
            this.knlExceptionService.process(vo);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            json.setSuccess(false);
            json.setMsg("\u5904\u7406\u5931\u8d25");
        }
        return json;
    }

    @GetMapping(value={"getKnlExceptionEntity"})
    public AjaxJson<KnlExceptionEntity> getKnlExceptionEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlExceptionEntity entity = this.knlExceptionService.getKnlExceptionEntity(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }
}

