/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.exception.service.impl;

import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.exception.dao.KnlExceptionDao;
import com.biz.eisp.base.exception.service.KnlExceptionService;
import com.biz.eisp.exception.entity.KnlExceptionEntity;
import com.biz.eisp.exception.vo.KnlExceptionVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="knlExceptionService")
@Transactional
public class KnlExceptionServiceImpl
extends BaseServiceImpl<KnlExceptionEntity>
implements KnlExceptionService {
    private static final Logger log = LoggerFactory.getLogger(KnlExceptionServiceImpl.class);
    @Autowired
    private KnlExceptionDao knlExceptionDao;

    @Override
    public List<KnlExceptionEntity> findKnlExceptionList(KnlExceptionVo vo) {
        Example example = new Example(KnlExceptionEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getApplicationName())) {
            criteria.andEqualTo("applicationName", (Object)vo.getApplicationName());
        }
        return this.knlExceptionDao.selectByExample(example);
    }

    @Override
    public PageInfo<KnlExceptionVo> findKnlExceptionPage(KnlExceptionVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.knlExceptionDao.findKnlExceptionList(vo), (Page)page);
    }

    @Override
    public KnlExceptionEntity getKnlExceptionEntity(String id) {
        return (KnlExceptionEntity)this.knlExceptionDao.selectByPrimaryKey(id);
    }

    @Override
    public List<KnlExceptionEntity> getKnlExceptionEntity(KnlExceptionVo vo) throws Exception {
        Example inexample = new Example(KnlExceptionEntity.class);
        Example.Criteria criteria = inexample.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            criteria.andNotEqualTo("id", (Object)vo.getId());
        }
        return this.knlExceptionDao.selectByExample(inexample);
    }

    @Override
    public void save(KnlExceptionVo vo) {
        KnlExceptionEntity entity = new KnlExceptionEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            this.insertSelective(entity);
        }
    }

    @Override
    public void update(KnlExceptionVo vo) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            KnlExceptionEntity entity = (KnlExceptionEntity)this.knlExceptionDao.selectByPrimaryKey(vo.getId());
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.updateByPrimaryKeySelective(entity);
        }
    }

    @Override
    public boolean delete(String id) {
        int i = this.knlExceptionDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public void process(KnlExceptionVo vo) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            KnlExceptionEntity entity = new KnlExceptionEntity();
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.updateByPrimaryKeySelective(entity);
        }
    }

    @Override
    public List<KnlExceptionVo> getKnlExceptionLine(KnlExceptionVo vo) {
        return this.knlExceptionDao.getKnlExceptionLine(vo);
    }

    @Override
    public List<KnlExceptionVo> getKnlExceptionCake(KnlExceptionVo vo) {
        return this.knlExceptionDao.getKnlExceptionCake(vo);
    }
}

