/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.mdm;

import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.api.feign.TmOrgFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TagUtil;
import com.biz.eisp.base.notice.service.KnlNoticeService;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.notice.entity.KnlNoticeEntity;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.tree.TreeGrid;
import com.biz.eisp.tree.TreeGridModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/tmApiOrganController"})
@RestController
public class TmApiOrganController {
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private KnlNoticeService knlNoticeService;
    @Autowired
    private TmOrgFeign tmOrgFeign;

    @RequestMapping(value={"findOrgListMainPage"})
    @ResponseBody
    public DataGrid findOrgListMainPage(HttpServletRequest request, TmOrgVo tmOrgVo) {
        Page page = new Page();
        page.setRows(tmOrgVo.getRows());
        page.setPage(tmOrgVo.getPage());
        AjaxJson ajaxJson = this.tmOrgFeign.findOrgListMainPage(tmOrgVo);
        if (null != ajaxJson) {
            if (null != ajaxJson.getPageInfo()) {
                return new DataGrid(ajaxJson.getPageInfo());
            }
            return new DataGrid(new ArrayList(), page);
        }
        return new DataGrid(new ArrayList(), page);
    }

    @RequestMapping(value={"findTmOrgList"})
    @ResponseBody
    public List<TreeGrid> findTmOrgList(TmOrgVo tmOrgEntity, String noticeId) {
        KnlNoticeEntity noticeEntity = null;
        if (null != noticeId) {
            noticeEntity = this.knlNoticeService.getKnlNoticeEntity(noticeId);
        }
        List<TreeGrid> treeGrids = null;
        String orgId = tmOrgEntity.getId();
        String orgCode = tmOrgEntity.getOrgCode();
        String orgName = tmOrgEntity.getOrgName();
        if (!StringUtils.isEmpty((CharSequence)orgId)) {
            AjaxJson ajaxJson = this.mdmApiFeign.getOrgList(orgId, orgCode);
            if (ajaxJson != null) {
                for (TmOrgVo orgEntity : ajaxJson.getObjList()) {
                    treeGrids = this.treeGridModel(orgEntity.getTmOrgList(), noticeEntity);
                }
            }
        } else {
            AjaxJson ajaxJson = this.mdmApiFeign.getOrgListNew(orgId, orgCode, orgName);
            if (ajaxJson != null) {
                treeGrids = this.treeGridModel(ajaxJson.getObjList(), noticeEntity);
            }
        }
        return treeGrids;
    }

    private List<TreeGrid> treeGridModel(List<TmOrgVo> orgList, KnlNoticeEntity noticeEntity) {
        List<TreeGrid> treeGrids = new ArrayList<TreeGrid>();
        if (CollectionUtil.listEmpty(orgList)) {
            return treeGrids;
        }
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("orgCode");
        treeGridModel.setSrc("orgName");
        treeGridModel.setParentId("parentId");
        treeGridModel.setFunctionType("orgType");
        treeGridModel.setIdField("id");
        treeGridModel.setParentText("orgDesc");
        treeGridModel.setChildList("tmOrgList");
        treeGrids = this.treegrid(orgList, treeGridModel, noticeEntity);
        return treeGrids;
    }

    private List<TreeGrid> treegrid(List all, TreeGridModel treeGridModel, KnlNoticeEntity noticeEntity) {
        ArrayList<TreeGrid> treegrid = new ArrayList<TreeGrid>();
        for (Object obj : all) {
            Object icon;
            ReflectHelper reflectHelper = new ReflectHelper(obj);
            TreeGrid tg = new TreeGrid();
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getCode())) {
                String code = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getCode()));
                tg.setCode(code);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getOrder())) {
                String order = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getOrder()));
                tg.setOrder(order);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getIdField())) {
                String id = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getIdField()));
                tg.setId(id);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getSrc())) {
                String src = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getSrc()));
                tg.setSrc(src);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getTextField())) {
                String text = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getTextField()));
                tg.setText(text);
                if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getIdField())) {
                    String[] strings;
                    String id = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getIdField()));
                    if (null != noticeEntity && noticeEntity.getReceivingOrgCode() != null && (strings = noticeEntity.getReceivingOrgCode().split(",")) != null && strings.length > 0) {
                        for (int i = 0; i < strings.length; ++i) {
                            if (!text.equals(strings[i])) continue;
                            tg.setCk("true");
                            tg.setSelect(id);
                            tg.setCheckOnSelect(true);
                        }
                    }
                }
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getParentText())) {
                String orgDesc = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getParentText()));
                tg.setParentText(orgDesc);
            }
            if (treeGridModel.getParentId() != null) {
                Object pid = TagUtil.fieldNametoValues((String)treeGridModel.getParentId(), obj);
                if (pid != null) {
                    tg.setParentId(pid.toString());
                } else {
                    tg.setParentId("");
                }
            }
            if (treeGridModel.getIcon() != null && (icon = TagUtil.fieldNametoValues((String)treeGridModel.getIcon(), obj)) != null) {
                tg.setIcon(icon.toString());
            }
            List childList = (List)reflectHelper.getMethodValue(treeGridModel.getChildList());
            ArrayList childTreeGridList = new ArrayList();
            if (childList != null && childList.size() > 0) {
                tg.setState("closed");
            }
            if (treeGridModel.getFieldMap() != null) {
                tg.setFieldMap(new HashMap());
                for (Map.Entry entry : treeGridModel.getFieldMap().entrySet()) {
                    Object fieldValue = reflectHelper.getMethodValue(entry.getValue().toString());
                    tg.getFieldMap().put(entry.getKey(), fieldValue);
                }
            }
            treegrid.add(tg);
        }
        return treegrid;
    }

    @RequestMapping(value={"findTmOrgTypeList"})
    @ResponseBody
    public List<KnlDictDataEntity> findTmOrgTypeList() {
        List list = DictUtil.getDictList((String)"org_type");
        return list;
    }

    @RequestMapping(value={"findOrgSelectTree"})
    public List<TreeGrid> findOrgSelectTree(TmOrgVo tmOrgEntity, String noticeId) {
        List<TreeGrid> list = this.findTmOrgList(tmOrgEntity, noticeId);
        list.forEach(e -> e.setText(e.getSrc()));
        return list;
    }
}

