/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.notice.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.notice.service.KnlNoticeReadService;
import com.biz.eisp.base.notice.service.KnlNoticeService;
import com.biz.eisp.notice.entity.KnlNoticeReadEntity;
import com.biz.eisp.notice.vo.KnlNoticeReadVo;
import com.biz.eisp.notice.vo.KnlNoticeVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/knlNoticeController"})
public class KnlNoticeController {
    @Autowired
    private KnlNoticeService knlNoticeService;
    @Autowired
    private KnlNoticeReadService knlNoticeReadService;

    @RequestMapping(value={"findKnlNoticePage"})
    @ResponseBody
    public DataGrid findKnlNoticePage(HttpServletRequest request, KnlNoticeVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<KnlNoticeVo> knlNoticeVoPageInfo = this.knlNoticeService.findKnlNoticePage(vo, (Page)page);
        if (knlNoticeVoPageInfo != null) {
            for (KnlNoticeVo noticeVo : knlNoticeVoPageInfo.getList()) {
                KnlNoticeReadVo knlNoticeReadVo = new KnlNoticeReadVo();
                knlNoticeReadVo.setNoticeId(noticeVo.getId());
                List<KnlNoticeReadEntity> knlNoticeReadEntities = this.knlNoticeReadService.getKnlNoticeReadList(knlNoticeReadVo);
                if (knlNoticeReadEntities != null && knlNoticeReadEntities.size() > 0) {
                    noticeVo.setVisitNum(Integer.valueOf(knlNoticeReadEntities.size()));
                    continue;
                }
                noticeVo.setVisitNum(Integer.valueOf(0));
            }
            return new DataGrid(knlNoticeVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(KnlNoticeVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.knlNoticeService.update(vo);
            } else {
                this.knlNoticeService.save(vo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"deleteNotice"})
    public AjaxJson deleteNotice(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlNoticeService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }
}

