/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.online.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.user.UserLoginRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.websocket.OnlineUserApiFeign;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/onlineUserController"})
public class OnlineUserController {
    @Autowired
    private OnlineUserApiFeign onlineUserApiFeign;
    @Autowired
    private RedisService redisService;

    @RequestMapping(value={"goOnlineMain"})
    public ModelAndView goOnlineMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/online/onlineMain");
    }

    @RequestMapping(value={"getOnlieUserList"})
    @ResponseBody
    public DataGrid getOnlieUserList(HttpServletRequest request, UserLoginRedis vo) {
        ArrayList list = this.onlineUserApiFeign.getOnlieUserList(vo);
        if (CollectionUtil.listEmpty((List)list)) {
            list = new ArrayList();
        }
        return new DataGrid(list);
    }

    @RequestMapping(value={"offLineUser"})
    @ResponseBody
    public AjaxJson offLineUser(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.onlineUserApiFeign.offLineUser(id);
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"sendUserMsg"})
    @ResponseBody
    public AjaxJson sendUserMsg(UserLoginRedis userLoginRedis) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            ajaxJson = this.onlineUserApiFeign.sendMsgUser(userLoginRedis.getId(), userLoginRedis.getContent());
        }
        catch (Exception e) {
            ajaxJson.setErrMsg("\u63a8\u9001\u6d88\u606f\u5931\u8d25");
            e.printStackTrace();
        }
        return ajaxJson;
    }

    @RequestMapping(value={"goSendMsgMain"})
    public ModelAndView goSendMsgMain(HttpServletRequest request, String id) {
        UserLoginRedis userLoginRedis = new UserLoginRedis();
        Object object = this.redisService.hget("GLOBAL_USER_", id);
        if (object != null) {
            userLoginRedis = (UserLoginRedis)object;
        }
        request.setAttribute("vo", (Object)userLoginRedis);
        return new ModelAndView("com/biz/eisp/online/sendMsg");
    }
}

