/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.sql.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.sql.dao.KnlSqlConfigDao;
import com.biz.eisp.base.sql.dao.KnlSqlLogDao;
import com.biz.eisp.base.sql.service.SqlService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.sql.entity.KnlSqlConfigEntity;
import com.biz.eisp.sql.entity.KnlSqlLogEntity;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="sqlService")
@Transactional
public class SqlServiceImpl
implements SqlService {
    @Autowired
    private KnlSqlConfigDao knlSqlConfigDao;
    @Autowired
    private KnlSqlLogDao knlSqlLogDao;

    @Override
    public PageInfo<KnlSqlConfigEntity> getSqlList(KnlSqlConfigEntity sqlConfigEntity, Page page) {
        Example example = new Example(KnlSqlConfigEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)sqlConfigEntity.getSqlKey())) {
            criteria.andLike("sqlKey", "%" + sqlConfigEntity.getSqlKey() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)sqlConfigEntity.getStatus())) {
            criteria.andEqualTo("status", (Object)sqlConfigEntity.getStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)sqlConfigEntity.getNotes())) {
            criteria.andLike("notes", "%" + sqlConfigEntity.getNotes() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)sqlConfigEntity.getSqlContent())) {
            criteria.andLike("sqlContent", "%" + sqlConfigEntity.getSqlContent() + "%");
        }
        if (StringUtil.isNotEmpty((Object)sqlConfigEntity.getLimiteTime())) {
            criteria.andLike("limiteTime", "%" + sqlConfigEntity.getLimiteTime() + "%");
        }
        return PageAutoHelperUtil.generatePage(() -> this.knlSqlConfigDao.selectByExample(example), (Page)page);
    }

    @Override
    public PageInfo<KnlSqlLogEntity> getSqlLogList(KnlSqlLogEntity knlSqlLogEntity, Page page) {
        Example example = new Example(KnlSqlLogEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)knlSqlLogEntity.getSqlKey())) {
            criteria.andLike("sqlKey", "%" + knlSqlLogEntity.getSqlKey() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)knlSqlLogEntity.getExecuteStatus())) {
            criteria.andEqualTo("executeStatus", (Object)knlSqlLogEntity.getExecuteStatus());
        }
        return PageAutoHelperUtil.generatePage(() -> this.knlSqlLogDao.selectByExample(example), (Page)page);
    }

    @Override
    public KnlSqlConfigEntity getKnlSqlConfigEntityById(String id) {
        return (KnlSqlConfigEntity)this.knlSqlConfigDao.selectByPrimaryKey(id);
    }

    @Override
    public KnlSqlLogEntity getSqlDetail(String id) {
        return (KnlSqlLogEntity)this.knlSqlLogDao.selectByPrimaryKey(id);
    }

    @Override
    public AjaxJson saveData(KnlSqlConfigEntity knlSqlConfigEntity, AjaxJson ajaxJson) {
        this.knlSqlConfigDao.insertSelective(knlSqlConfigEntity);
        return ajaxJson;
    }

    @Override
    public AjaxJson updateData(KnlSqlConfigEntity knlSqlConfigEntity, AjaxJson ajaxJson) {
        knlSqlConfigEntity.setSqlKey(null);
        this.knlSqlConfigDao.updateByPrimaryKeySelective(knlSqlConfigEntity);
        return ajaxJson;
    }
}

