/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.api.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.configure.service.KnlFormConfigService;
import com.biz.eisp.base.configure.service.KnlFormInitService;
import com.biz.eisp.base.configure.service.KnlTableConfigService;
import com.biz.eisp.base.configure.service.KnlTableInitService;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.configure.entity.KnlFormConfigEntity;
import com.biz.eisp.configure.entity.KnlTableConfigEntity;
import com.biz.eisp.configure.vo.KnlFormConfigVo;
import com.biz.eisp.configure.vo.KnlTableConfigVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@Api(tags={"KERNEL\u57fa\u7840\u529f\u80fd"}, description="CRM-BASE KERNEL\u57fa\u7840\u529f\u80fd")
@RestController
@RequestMapping(value={"/kernel-api/knlApiTableConfiController"})
public class KnlApiTableConfiController {
    @Autowired
    private KnlTableConfigService knlTableConfigService;
    @Autowired
    private KnlFormConfigService knlFormConfigService;
    @Autowired
    private KnlTableInitService knlTableInitService;
    @Autowired
    private KnlFormInitService knlFormInitService;

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8868\u5355\u914d\u7f6e", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8868\u5355\u914d\u7f6e,\u8fd4\u56de\u503c\u5728objList", httpMethod="POST")
    @PostMapping(value={"getTableConfigByParam"})
    public AjaxJson<KnlTableConfigEntity> getTableConfigByParam(@RequestBody KnlTableConfigVo tableConfigVo) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(KnlTableConfigEntity.class);
        Example.Criteria criteria = example.createCriteria();
        example.orderBy("showOrder").asc();
        if (StringUtils.isNotBlank((CharSequence)tableConfigVo.getUserName())) {
            criteria.andEqualTo("userName", (Object)tableConfigVo.getUserName());
        } else {
            criteria.andIsNull("userName");
        }
        if (StringUtils.isBlank((CharSequence)tableConfigVo.getFunctionId())) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u67e5\u627e\u76ee\u6807,\u914d\u7f6e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return ajaxJson;
        }
        criteria.andEqualTo("functionId", (Object)tableConfigVo.getFunctionId());
        List configVos = this.knlTableConfigService.selectExample(example);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)configVos)) {
            Example exampleFirst = new Example(KnlTableConfigEntity.class);
            Example.Criteria criteriaFirst = exampleFirst.createCriteria();
            criteriaFirst.andEqualTo("functionId", (Object)tableConfigVo.getFunctionId());
            criteriaFirst.andIsNull("userName");
            configVos = this.knlTableConfigService.selectExample(exampleFirst);
        }
        if (tableConfigVo.getIsInit().booleanValue()) {
            this.knlTableInitService.initSync(configVos, tableConfigVo.getUserName());
        }
        ajaxJson.setObjList(configVos);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8868\u5355Form\u914d\u7f6e", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8868\u5355Form\u914d\u7f6e,\u8fd4\u56de\u503c\u5728objList", httpMethod="POST")
    @PostMapping(value={"getFormConfigByParam"})
    public AjaxJson<KnlFormConfigEntity> getFormConfigByParam(@RequestBody KnlFormConfigVo knlFormConfigVo) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(KnlFormConfigEntity.class);
        Example.Criteria criteria = example.createCriteria();
        example.orderBy("showOrder").asc();
        if (StringUtils.isBlank((CharSequence)knlFormConfigVo.getFunctionId())) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u67e5\u627e\u76ee\u6807,\u914d\u7f6e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return ajaxJson;
        }
        criteria.andEqualTo("functionId", (Object)knlFormConfigVo.getFunctionId());
        List configVos = this.knlFormConfigService.selectExample(example);
        this.knlFormInitService.initSync(configVos);
        ajaxJson.setObjList(configVos);
        return ajaxJson;
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e2a\u6027\u5316\u8bbe\u7f6e", notes="\u4fdd\u5b58\u4e2a\u6027\u5316\u8bbe\u7f6e,\u8fd4\u56de\u503c\u5728boolean", httpMethod="POST")
    @PostMapping(value={"saveSelectList"})
    public AjaxJson<String> saveSelectList(@RequestParam(value="selectJSON") String selectJSON, @RequestParam(value="functionId") String functionId) {
        AjaxJson ajaxJson = new AjaxJson();
        JSONArray array = JSONArray.parseArray((String)selectJSON);
        String userName = UserUtils.getUser().getUsername();
        if (StringUtils.isEmpty((CharSequence)userName)) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        HashMap<String, KnlTableConfigEntity> inSet = new HashMap<String, KnlTableConfigEntity>();
        AtomicInteger showOrder = new AtomicInteger(0);
        if (array != null && array.size() > 0) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject object = array.getJSONObject(i);
                String field = object.getString("field");
                String query = object.getString("query");
                KnlTableConfigEntity knlTableConfigEntity = new KnlTableConfigEntity();
                knlTableConfigEntity.setField(field);
                if (StringUtils.equals((CharSequence)query, (CharSequence)"true")) {
                    knlTableConfigEntity.setIsSearch("1");
                } else {
                    knlTableConfigEntity.setIsSearch("0");
                }
                if (!StringUtils.isNotBlank((CharSequence)field)) continue;
                knlTableConfigEntity.setShowOrder(Integer.valueOf(showOrder.get()));
                showOrder.getAndIncrement();
                inSet.put(field, knlTableConfigEntity);
            }
        }
        if (inSet != null && inSet.size() > 0) {
            Example exampleSelf = new Example(KnlTableConfigEntity.class);
            Example.Criteria criteriaSelf = exampleSelf.createCriteria();
            criteriaSelf.andEqualTo("functionId", (Object)functionId);
            criteriaSelf.andEqualTo("userName", (Object)userName);
            this.knlTableConfigService.deleteByExample(exampleSelf);
            Example example = new Example(KnlTableConfigEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("functionId", (Object)functionId);
            criteria.andIsNull("userName");
            List entities = this.knlTableConfigService.selectExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)entities)) {
                entities.forEach(item -> {
                    if (inSet.containsKey(item.getField())) {
                        item.setIsHide("0");
                        item.setIsSearch(((KnlTableConfigEntity)inSet.get(item.getField())).getIsSearch());
                        item.setShowOrder(((KnlTableConfigEntity)inSet.get(item.getField())).getShowOrder());
                    } else {
                        item.setIsHide("1");
                    }
                    item.setId(null);
                    item.setUserName(userName);
                    item.setCreateName(userName);
                    item.setCreateDate(null);
                    item.setUpdateBy(null);
                    item.setUpdateDate(null);
                    item.setPositionCode(null);
                    item.setPositionName(null);
                });
                this.knlTableConfigService.insertList(entities);
                this.knlTableInitService.initSync(entities, userName);
            }
        }
        return ajaxJson;
    }

    @GetMapping(value={"restSave"})
    public AjaxJson restSave(@RequestParam(value="functionId") String functionId, @RequestParam(value="userName") String userName) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtils.isEmpty((CharSequence)functionId) || StringUtils.isEmpty((CharSequence)userName)) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        this.knlTableConfigService.restSave(functionId, userName);
        return ajaxJson;
    }

    @GetMapping(value={"getKnlTableConfigEntity"})
    public AjaxJson<KnlTableConfigEntity> getKnlTableConfigEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlTableConfigEntity entity = this.knlTableConfigService.getKnlTableConfigEntity(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }
}

