/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.parameter.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.parameter.dao.KnlParameterManageDao;
import com.biz.eisp.base.parameter.service.KnlParameterManageService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.parameter.entity.KnlParameterManageEntity;
import com.biz.eisp.parameter.vo.KnlParameterManageVo;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="knlParameterManageService")
@Transactional
public class KnlParameterManageServiceImplImpl
extends BaseServiceImpl<KnlParameterManageEntity>
implements KnlParameterManageService {
    @Autowired
    private KnlParameterManageDao knlParameterManageDao;
    @Autowired
    private RedisService redisService;

    @Override
    public List<KnlParameterManageVo> findKnlParameterManageList(KnlParameterManageVo vo) {
        return this.knlParameterManageDao.findKnlParameterManageList(vo);
    }

    @Override
    public PageInfo<KnlParameterManageVo> findKnlParameterManagePage(KnlParameterManageVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.knlParameterManageDao.findKnlParameterManageList(vo), (Page)page);
    }

    @Override
    public KnlParameterManageEntity getKnlParameterManageEntity(String id, String code) {
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            return (KnlParameterManageEntity)this.knlParameterManageDao.selectByPrimaryKey(id);
        }
        if (StringUtil.isNotEmpty((CharSequence)code)) {
            Example example = new Example(KnlParameterManageEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("parameterCode", (Object)code);
            List list = this.knlParameterManageDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                return (KnlParameterManageEntity)list.get(0);
            }
        }
        return null;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=KnlParameterManageServiceImplImpl.class)
    public void save(KnlParameterManageVo vo) throws Exception {
        KnlParameterManageEntity entity = new KnlParameterManageEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.insertSelective(entity);
        }
        this.redisService.setDays("SYS_PARAM_" + entity.getParameterCode(), (Object)entity, 3650L);
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=KnlParameterManageServiceImplImpl.class)
    public void update(KnlParameterManageVo vo) throws Exception {
        KnlParameterManageEntity entity = new KnlParameterManageEntity();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (KnlParameterManageEntity)this.knlParameterManageDao.selectByPrimaryKey(vo.getId());
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.updateByPrimaryKeySelective(entity);
        }
        this.redisService.del(new String[]{"SYS_PARAM_" + entity.getParameterCode()});
    }

    @Override
    public List<KnlParameterManageEntity> getKnlParameterManageEntity(KnlParameterManageVo vo) throws Exception {
        Example inexample = new Example(KnlParameterManageEntity.class);
        Example.Criteria criteria = inexample.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            criteria.andNotEqualTo("id", (Object)vo.getId());
        }
        return this.knlParameterManageDao.selectByExample(inexample);
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=KnlParameterManageServiceImplImpl.class)
    public boolean delete(String id) {
        KnlParameterManageEntity parameterEntity = (KnlParameterManageEntity)this.knlParameterManageDao.selectByPrimaryKey(id);
        int i = this.knlParameterManageDao.deleteByPrimaryKey(id);
        if (i > 0) {
            this.redisService.del(new String[]{"PARAMETER_MANAGE_" + parameterEntity.getParameterCode()});
            return true;
        }
        return false;
    }
}

