/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.dict.controller;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.dict.service.KnlDictDataService;
import com.biz.eisp.base.dict.service.KnlDictTypeService;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.dict.vo.KnlDictDataVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"/knlDictDataController"})
public class KnlDictDataController {
    @Autowired
    private KnlDictDataService knlDictDataService;
    @Autowired
    private KnlDictTypeService knlDictTypeService;

    @RequestMapping(value={"findKnlDictDataList"})
    public JSONArray findKnlDictDataList(HttpServletRequest request, KnlDictDataVo vo) {
        JSONArray list = this.knlDictDataService.findKnlDictDataList(vo);
        if (CollectionUtil.listEmpty((List)list)) {
            list = new JSONArray();
        }
        return list;
    }

    @GetMapping(value={"loadDictTypeKVByCodes"})
    public AjaxJson<Map<String, Map<String, String>>> loadDictTypeKVByCodes(String dictTypeCode) {
        AjaxJson j = new AjaxJson();
        if (StringUtils.isBlank((CharSequence)dictTypeCode)) {
            j.setObj((Object)Maps.newHashMap());
            return j;
        }
        HashSet codes = Sets.newHashSet((Object[])dictTypeCode.split(","));
        j.setObj(this.knlDictDataService.loadDictTypeKVByCodes(codes));
        return j;
    }

    @RequestMapping(value={"saveOrUpdate"})
    public AjaxJson saveOrUpdate(KnlDictDataVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.knlDictDataService.update(vo);
            } else {
                this.knlDictDataService.save(vo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(value={"delete"})
    public AjaxJson delete(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlDictDataService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"validateDataCode"})
    public ValidForm validateDataCode(HttpServletRequest request, String parentId, String id, String dictTypeCode) {
        String param = OConvertUtils.getString((String)request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        try {
            List list;
            Example example = new Example(KnlDictDataEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("dictCode", (Object)param);
            criteria.andEqualTo("dictTypeCode", (Object)dictTypeCode);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                criteria.andNotEqualTo("id", (Object)id);
            }
            if (StringUtils.isNotBlank((CharSequence)parentId)) {
                criteria.andEqualTo("parentId", (Object)parentId);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.knlDictDataService.selectExample(example)))) {
                validForm.setStatus("n");
                validForm.setInfo("\u6570\u636e\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validForm;
    }

    @GetMapping(value={"getDictDataById"})
    public AjaxJson<KnlDictDataEntity> getDictDataById(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlDictDataEntity entity = this.knlDictDataService.getDictDataById(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @GetMapping(value={"getKnlDictDataList"})
    AjaxJson<KnlDictDataEntity> getKnlDictDataList() {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(KnlDictDataEntity.class);
        Example.Criteria criteria_ = example.createCriteria();
        criteria_.andEqualTo("dictTypeCode", (Object)"notice_type");
        List dataEntities = this.knlDictDataService.selectExample(example);
        ajaxJson.setList(dataEntities);
        return ajaxJson;
    }
}

