/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.dict.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.dict.dao.KnlDictConfDao;
import com.biz.eisp.base.dict.dao.KnlDictDataDao;
import com.biz.eisp.base.dict.dao.KnlDictExtendDao;
import com.biz.eisp.base.dict.dao.KnlDictTypeDao;
import com.biz.eisp.base.dict.service.KnlDictInitService;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.dict.entity.KnlDictExtendsEntitiy;
import com.biz.eisp.dict.entity.KnlDictTypeEntity;
import com.biz.eisp.service.RedisService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="knlDictInitService")
public class KnlDictInitServiceImpl
implements KnlDictInitService {
    @Autowired
    private KnlDictConfDao knlDictConfDao;
    @Autowired
    private KnlDictDataDao knlDictDataDao;
    @Autowired
    private KnlDictExtendDao knlDictExtendDao;
    @Autowired
    private KnlDictTypeDao knlDictTypeDao;
    @Autowired
    private RedisService redisService;

    @Override
    public void initDictConfToRedis() {
    }

    @Override
    public void initDictToRedis(List<KnlDictDataEntity> datas) {
        if (CollectionUtil.listNotEmptyNotSizeZero(datas)) {
            datas.forEach(dataItem -> this.redisService.hset("DICT_DATA_" + dataItem.getDictTypeCode(), dataItem.getDictCode(), dataItem));
        }
    }

    @Override
    public void getData(List<KnlDictTypeEntity> types, List<KnlDictDataEntity> datas, List<KnlDictExtendsEntitiy> etds) {
        if (CollectionUtil.listNotEmptyNotSizeZero(types) && CollectionUtil.listNotEmptyNotSizeZero(datas) && CollectionUtil.listNotEmptyNotSizeZero(etds)) {
            types.forEach(typeEntity -> this.redisService.hset("DICT_TYPE_", typeEntity.getDictTypeCode(), typeEntity));
            Map<String, List<KnlDictExtendsEntitiy>> extendMap = etds.stream().collect(Collectors.groupingBy(KnlDictExtendsEntitiy::getDictDataId));
            datas.forEach(dataItem -> {
                HashMap resultMap = new HashMap();
                if (extendMap.containsKey(dataItem.getId())) {
                    List dataexts = (List)extendMap.get(dataItem.getId());
                    dataexts.forEach(extEntity -> resultMap.put(extEntity.getFieldCode(), extEntity.getExtendValue()));
                    dataItem.setExtendMap(resultMap);
                }
            });
        }
    }
}

