/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.api.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.dict.dao.KnlDictExtendDao;
import com.biz.eisp.base.dict.service.KnlDictConfService;
import com.biz.eisp.base.dict.service.KnlDictDataService;
import com.biz.eisp.base.dict.service.KnlDictInitService;
import com.biz.eisp.base.dict.service.KnlDictTypeService;
import com.biz.eisp.dict.entity.KnlDictAttributeConfEntity;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.dict.entity.KnlDictExtendsEntitiy;
import com.biz.eisp.dict.entity.KnlDictTypeEntity;
import com.biz.eisp.service.RedisService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@Api(tags={"KERNEL\u57fa\u7840\u529f\u80fd"}, description="CRM-BASE KERNEL\u57fa\u7840\u529f\u80fd\u5b57\u5178")
@RestController
@RequestMapping(value={"/kernel-api/knlApiDictController"})
public class KnlApiDictController {
    @Autowired
    private KnlDictDataService knlDictDataService;
    @Autowired
    private KnlDictTypeService knlDictTypeService;
    @Autowired
    private KnlDictInitService knlDictInitService;
    @Autowired
    private KnlDictExtendDao knlDictExtendDao;
    @Autowired
    private KnlDictConfService knlDictConfService;
    @Autowired
    private RedisService redisService;

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5b57\u5178\u914d\u7f6e", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5b57\u5178\u914d\u7f6e,\u8fd4\u56de\u503c\u5728objList", httpMethod="POST")
    @PostMapping(value={"getDictByParamList"})
    public AjaxJson<KnlDictDataEntity> getDictByParamList(@RequestParam(value="dictTypeCode") String dictTypeCode) {
        List dataEntities;
        AjaxJson ajaxJson = new AjaxJson();
        Example exampletype = new Example(KnlDictTypeEntity.class);
        Example.Criteria criteria = exampletype.createCriteria();
        if (StringUtils.isBlank((CharSequence)dictTypeCode)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u5b57\u5178key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return ajaxJson;
        }
        criteria.andEqualTo("dictTypeCode", (Object)dictTypeCode);
        List types = this.knlDictTypeService.selectExample(exampletype);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)types)) {
            Example example = new Example(KnlDictDataEntity.class);
            Example.Criteria criteria_ = example.createCriteria();
            criteria_.andEqualTo("dictTypeCode", (Object)dictTypeCode);
            dataEntities = this.knlDictDataService.selectExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)dataEntities)) {
                Example exampleExtends = new Example(KnlDictExtendsEntitiy.class);
                Example.Criteria criteria_Extends = exampleExtends.createCriteria();
                List ids = dataEntities.stream().map(KnlDictDataEntity::getId).collect(Collectors.toList());
                criteria_Extends.andIn("dictDataId", ids);
                List etds = this.knlDictExtendDao.selectByExample(exampleExtends);
                this.knlDictInitService.getData(types, dataEntities, etds);
                this.knlDictInitService.initDictToRedis(dataEntities);
            }
        } else {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u6ca1\u6709\u914d\u7f6e\u6570\u636e\uff01");
            return ajaxJson;
        }
        ajaxJson.setObjList(dataEntities);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5b57\u5178\u914d\u7f6e", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5b57\u5178\u914d\u7f6e,\u8fd4\u56de\u503c\u5728obj", httpMethod="POST")
    @PostMapping(value={"getDictByParamObj"})
    public AjaxJson<KnlDictDataEntity> getDictByParamObj(@RequestParam(value="dictTypeCode") String dictTypeCode, @RequestParam(value="dictCode") String dictCode) {
        AjaxJson ajaxJson = new AjaxJson();
        Example exampletype = new Example(KnlDictTypeEntity.class);
        Example.Criteria criteria = exampletype.createCriteria();
        if (StringUtils.isBlank((CharSequence)dictTypeCode)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u5b57\u5178key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return ajaxJson;
        }
        criteria.andEqualTo("dictTypeCode", (Object)dictTypeCode);
        List types = this.knlDictTypeService.selectExample(exampletype);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)types)) {
            Example example = new Example(KnlDictDataEntity.class);
            Example.Criteria criteria_ = example.createCriteria();
            criteria_.andEqualTo("dictTypeCode", (Object)dictTypeCode);
            criteria_.andEqualTo("dictCode", (Object)dictCode);
            List dataEntities = this.knlDictDataService.selectExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)dataEntities)) {
                Example exampleExtends = new Example(KnlDictExtendsEntitiy.class);
                Example.Criteria criteria_Extends = exampleExtends.createCriteria();
                List ids = dataEntities.stream().map(KnlDictDataEntity::getId).collect(Collectors.toList());
                criteria_Extends.andIn("dictDataId", ids);
                List etds = this.knlDictExtendDao.selectByExample(exampleExtends);
                this.knlDictInitService.getData(types, dataEntities, etds);
                ajaxJson.setObj(dataEntities.get(0));
                this.getDictByParamList(dictTypeCode);
            }
        } else {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u6ca1\u6709\u914d\u7f6e\u6570\u636e\uff01");
            return ajaxJson;
        }
        return ajaxJson;
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u914d\u7f6e\u5c5e\u6027", notes="\u6839\u83b7\u53d6\u5b57\u5178\u914d\u7f6e\u5c5e\u6027,\u8fd4\u56de\u503c\u5728obj", httpMethod="POST")
    @PostMapping(value={"getDictAttribute"})
    public AjaxJson<KnlDictAttributeConfEntity> getDictAttribute(@RequestParam(value="dictTypeCode") String dictTypeCode) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(KnlDictAttributeConfEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((CharSequence)dictTypeCode)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u5b57\u5178key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return ajaxJson;
        }
        criteria.andEqualTo("dictTypeCode", (Object)dictTypeCode);
        List confs = this.knlDictConfService.selectExample(example);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)confs)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u6ca1\u6709\u914d\u7f6e\u6570\u636e\uff01");
            return ajaxJson;
        }
        HashMap attribu = new HashMap();
        confs.forEach(item -> this.redisService.hset("DICT_CONF_" + item.getDictTypeCode(), item.getFieldCode(), item));
        ajaxJson.setObjList(confs);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u7236\u7ea7\u522bid\u67e5\u8be2\u5b57\u5178\u5217\u8868", notes="\u6839\u636e\u7236\u7ea7\u522bid\u67e5\u8be2\u5b57\u5178\u5217\u8868", httpMethod="GET")
    @PostMapping(value={"getDictListByParentId"})
    public AjaxJson<KnlDictDataEntity> getDictListByParentId(@RequestParam(value="parentId") String parentId) {
        AjaxJson ajaxJson = new AjaxJson();
        ArrayList list = new ArrayList();
        if (StringUtils.isBlank((CharSequence)parentId)) {
            ajaxJson.setObjList(list);
            return ajaxJson;
        }
        Example example = new Example(KnlDictDataEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("parentId", (Object)parentId);
        list = this.knlDictDataService.selectExample(example);
        list = CollectionUtil.listEmpty(list) ? new ArrayList() : list;
        this.redisService.set(parentId, list);
        ajaxJson.setObjList(list);
        return ajaxJson;
    }
}

