/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.notice.controller;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.notice.service.KnlNoticeReadService;
import com.biz.eisp.base.notice.service.KnlNoticeService;
import com.biz.eisp.base.pojo.glob.vo.BaseVo;
import com.biz.eisp.notice.entity.KnlNoticeReadEntity;
import com.biz.eisp.notice.vo.KnlNoticeVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/knlNoticeController"})
public class KnlNoticeController {
    @Autowired
    private KnlNoticeService knlNoticeService;
    @Autowired
    private KnlNoticeReadService knlNoticeReadService;

    @RequestMapping(value={"findKnlNoticePage"})
    @ResponseBody
    public DataGrid findKnlNoticePage(HttpServletRequest request, KnlNoticeVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<KnlNoticeVo> knlNoticeVoPageInfo = this.knlNoticeService.findKnlNoticePage(vo, (Page)page);
        List<String> noticeIds = knlNoticeVoPageInfo.getList().stream().map(BaseVo::getId).collect(Collectors.toList());
        Map<String, List<KnlNoticeReadEntity>> knlNoticeReadEntitiesMap = this.knlNoticeReadService.getListByNoticeIds(noticeIds).stream().collect(Collectors.groupingBy(KnlNoticeReadEntity::getNoticeId));
        if (knlNoticeVoPageInfo != null) {
            for (KnlNoticeVo noticeVo : knlNoticeVoPageInfo.getList()) {
                List<KnlNoticeReadEntity> knlNoticeReadEntities = knlNoticeReadEntitiesMap.get(noticeVo.getId());
                if (knlNoticeReadEntities != null && knlNoticeReadEntities.size() > 0) {
                    noticeVo.setVisitNum(Integer.valueOf(knlNoticeReadEntities.size()));
                    Set readusers = knlNoticeReadEntities.stream().map(KnlNoticeReadEntity::getUserName).collect(Collectors.toSet());
                    noticeVo.setReadUserNum(Integer.valueOf(readusers.size()));
                    continue;
                }
                noticeVo.setVisitNum(Integer.valueOf(0));
                noticeVo.setReadUserNum(Integer.valueOf(0));
            }
            return new DataGrid(knlNoticeVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(KnlNoticeVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.knlNoticeService.update(vo);
            } else {
                this.knlNoticeService.save(vo);
            }
        }
        catch (UncategorizedSQLException e) {
            if (12899 == e.getSQLException().getErrorCode()) {
                j.setMsg("\u516c\u544a\u5185\u5bb9\u6700\u59274000\u4e2a\u5b57\u7b26");
            } else {
                j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            }
            j.setSuccess(false);
        }
        catch (BusinessException e) {
            j.setMsg(e.getMessage());
            j.setSuccess(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"deleteNotice"})
    public AjaxJson deleteNotice(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlNoticeService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }
}

