/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.notice.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.notice.dao.KnlNoticeReadDao;
import com.biz.eisp.base.notice.service.KnlNoticeReadService;
import com.biz.eisp.notice.entity.KnlNoticeReadEntity;
import com.biz.eisp.notice.vo.KnlNoticeReadVo;
import com.biz.eisp.service.BaseServiceImpl;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service(value="knlNoticeReadService")
@Transactional
public class KnlNoticeReadServiceImpl
extends BaseServiceImpl<KnlNoticeReadEntity>
implements KnlNoticeReadService {
    @Autowired
    private KnlNoticeReadDao knlNoticeReadDao;

    @Override
    public List<KnlNoticeReadEntity> getKnlNoticeReadList(KnlNoticeReadVo vo) {
        Example example = new Example(KnlNoticeReadEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getNoticeId())) {
            criteria.andEqualTo("noticeId", (Object)vo.getNoticeId());
        }
        return this.knlNoticeReadDao.selectByExample(example);
    }

    @Override
    public List<KnlNoticeReadEntity> getListByNoticeIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        Example example = new Example(KnlNoticeReadEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("noticeId", ids);
        return this.knlNoticeReadDao.selectByExample(example);
    }
}

