/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.sql.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.sql.service.SqlService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.sql.entity.KnlSqlConfigEntity;
import com.biz.eisp.sql.entity.KnlSqlLogEntity;
import com.github.pagehelper.PageInfo;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sqlController"})
public class SqlController {
    @Autowired
    private SqlService sqlService;

    @RequestMapping(value={"getSqlList"})
    public DataGrid getSqlList(HttpServletRequest request, KnlSqlConfigEntity knlSqlConfigEntity) {
        EuPage page = new EuPage(request);
        PageInfo<KnlSqlConfigEntity> pageInfo = this.sqlService.getSqlList(knlSqlConfigEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"updateOrAdd"})
    public AjaxJson updateOrAdd(HttpServletRequest request, KnlSqlConfigEntity knlSqlConfigEntity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isNotEmpty((CharSequence)knlSqlConfigEntity.getId()) ? this.sqlService.updateData(knlSqlConfigEntity, ajaxJson) : this.sqlService.saveData(knlSqlConfigEntity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"goSqlList"})
    public DataGrid goSqlList(HttpServletRequest request, KnlSqlLogEntity knlSqlLogEntity) {
        EuPage page = new EuPage(request);
        PageInfo<KnlSqlLogEntity> pageInfo = this.sqlService.getSqlLogList(knlSqlLogEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @GetMapping(value={"getKnlSqlConfigEntityById"})
    public AjaxJson<KnlSqlConfigEntity> getKnlSqlConfigEntityById(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlSqlConfigEntity entity = this.sqlService.getKnlSqlConfigEntityById(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @GetMapping(value={"getSqlDetail"})
    public AjaxJson<KnlSqlLogEntity> getSqlDetail(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlSqlLogEntity entity = this.sqlService.getSqlDetail(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }
}

