/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.dict.service.impl;

import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.dict.dao.KnlDictConfDao;
import com.biz.eisp.base.dict.service.KnlDictConfService;
import com.biz.eisp.dict.entity.KnlDictAttributeConfEntity;
import com.biz.eisp.dict.vo.KnlDictAttributeConfVo;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.util.EnableModifyLog;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="knlDictConfService")
@Transactional
public class KnlDictConfServiceImplImpl
extends BaseServiceImpl<KnlDictAttributeConfEntity>
implements KnlDictConfService {
    @Autowired
    private KnlDictConfDao knlDictConfDao;
    @Autowired
    private RedisService redisService;
    private static final String dictTypeCode = "dictTypeCode";
    private static final String fieldCode = "fieldCode";
    private static final String id = "id";

    @Override
    public List<KnlDictAttributeConfVo> findKnlDictAttributeConfVoList(KnlDictAttributeConfVo vo) {
        return this.knlDictConfDao.findKnlDictAttributeConfList(vo);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", handleName="\u5b57\u5178\u5c5e\u6027", serviceclass=BaseServiceImpl.class)
    public void save(KnlDictAttributeConfVo vo) throws Exception {
        KnlDictAttributeConfEntity entity = new KnlDictAttributeConfEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.insertSelective(entity);
        }
        this.redisService.del(new String[]{"DICT_CONF_" + entity.getDictTypeCode()});
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", handleName="\u5b57\u5178\u5c5e\u6027", serviceclass=BaseServiceImpl.class)
    public void update(KnlDictAttributeConfVo vo) throws Exception {
        KnlDictAttributeConfEntity entity = new KnlDictAttributeConfEntity();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (KnlDictAttributeConfEntity)this.knlDictConfDao.selectByPrimaryKey(vo.getId());
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.updateByPrimaryKeySelective(entity);
        }
        this.redisService.del(new String[]{"DICT_CONF_" + entity.getDictTypeCode()});
    }

    @Override
    public boolean checkValidate(KnlDictAttributeConfVo vo) throws Exception {
        Example inexample = new Example(KnlDictAttributeConfEntity.class);
        Example.Criteria criteria = inexample.createCriteria();
        criteria.andEqualTo(dictTypeCode, (Object)vo.getDictTypeCode());
        criteria.andEqualTo(fieldCode, (Object)vo.getFieldCode());
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            criteria.andNotEqualTo(id, (Object)vo.getId());
        }
        return this.knlDictConfDao.selectCountByExample(inexample) <= 0;
    }

    @Override
    public KnlDictAttributeConfEntity getConfById(String id) {
        return (KnlDictAttributeConfEntity)this.knlDictConfDao.selectByPrimaryKey(id);
    }

    @Override
    public boolean delete(String id) {
        KnlDictAttributeConfEntity entity = (KnlDictAttributeConfEntity)this.knlDictConfDao.selectByPrimaryKey(id);
        int i = this.knlDictConfDao.deleteByPrimaryKey(id);
        if (i > 0) {
            this.redisService.del(new String[]{"DICT_CONF_" + entity.getDictTypeCode()});
            return true;
        }
        return false;
    }
}

