/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.cache.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.cache.service.KnlCacheViewService;
import com.biz.eisp.base.common.util.RedisUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.RedisGlobalUtils;
import com.biz.eisp.cache.vo.KnlCacheViewVo;
import com.biz.eisp.service.RedisService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.DataType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="knlCacheViewService")
@Transactional
public class KnlCacheViewServiceImpl
implements KnlCacheViewService {
    @Autowired
    private static RedisService redisService;

    private static void getRedisService() {
        if (redisService == null) {
            redisService = RedisUtils.getRedisService();
        }
    }

    @Override
    public List<KnlCacheViewVo> getKnlCacheViewVoList(KnlCacheViewVo vo) {
        List<String> strings = this.getRedisGlobalUtils();
        KnlCacheViewServiceImpl.getRedisService();
        HashSet keysSet = new HashSet();
        ArrayList<KnlCacheViewVo> knlCacheViewVos = new ArrayList<KnlCacheViewVo>();
        if (null != vo.getKey()) {
            Set keys = redisService.keys(vo.getKey() + "*");
            keysSet.addAll(keys);
        } else {
            for (String str : strings) {
                Set keys = redisService.keys(str + "*");
                keysSet.addAll(keys);
            }
        }
        if (keysSet.size() > 0) {
            keysSet.stream().sorted(Comparator.reverseOrder());
            HashMap map = new HashMap();
            Map excludeKeyMap = RedisGlobalUtils.getListExcludeKey.stringMap;
            for (String key : keysSet) {
                boolean excludeKeyFalg = true;
                for (Map.Entry excludeKey : excludeKeyMap.entrySet()) {
                    String ek = (String)excludeKey.getKey();
                    if (key.indexOf(ek) <= -1) continue;
                    excludeKeyFalg = false;
                    break;
                }
                if (!excludeKeyFalg) continue;
                KnlCacheViewVo knlCacheViewVo = new KnlCacheViewVo();
                DataType dataType = redisService.type(key);
                if (dataType.code().equals("string")) {
                    Object obj = null;
                    obj = redisService.get(key);
                    if (obj != null) {
                        knlCacheViewVo.setId(key);
                        knlCacheViewVo.setKey(key);
                        knlCacheViewVo.setValue((Object)obj.toString());
                        knlCacheViewVos.add(knlCacheViewVo);
                    }
                }
                if (dataType.code().equals("hash")) {
                    JSONArray jsonArray = null;
                    List list = null;
                    try {
                        list = redisService.hvals(key);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (list != null && list.size() > 0) {
                        jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)list));
                    }
                    knlCacheViewVo.setId(key);
                    knlCacheViewVo.setKey(key);
                    if (jsonArray != null) {
                        knlCacheViewVo.setValue((Object)jsonArray.toJSONString());
                    }
                    knlCacheViewVos.add(knlCacheViewVo);
                }
                if (knlCacheViewVos.size() < 100) continue;
                break;
            }
        }
        return knlCacheViewVos;
    }

    private List<String> getRedisGlobalUtils() {
        Field[] fields;
        ArrayList<String> strings = new ArrayList<String>();
        for (Field field : fields = RedisGlobalUtils.class.getDeclaredFields()) {
            strings.add(field.getName());
        }
        Iterator iterator = strings.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals("CODE_RULE_INIT")) continue;
            iterator.remove();
        }
        return strings;
    }

    @Override
    public KnlCacheViewVo getKnlCacheViewVo(String id) {
        KnlCacheViewVo knlCacheViewVo = new KnlCacheViewVo();
        DataType dataType = redisService.type(id);
        if (dataType.code().equals("string") && !id.substring(0, 15).equals("CODE_RULE_INIT_")) {
            Object obj = redisService.get(id);
            knlCacheViewVo.setId(id);
            knlCacheViewVo.setKey(id);
            knlCacheViewVo.setValue((Object)obj.toString());
        }
        if (dataType.code().equals("hash")) {
            JSONArray jsonArray = null;
            List list = null;
            list = redisService.hvals(id);
            if (list != null && list.size() > 0) {
                jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)list));
            }
            knlCacheViewVo.setId(id);
            knlCacheViewVo.setKey(id);
            if (jsonArray != null) {
                knlCacheViewVo.setValue((Object)jsonArray.toJSONString());
            }
        }
        return knlCacheViewVo;
    }

    @Override
    public void deleteKnlCacheViewVo(String ids) {
        if (StringUtil.isNotEmpty((CharSequence)ids)) {
            for (String s : ids.split(",")) {
                redisService.del(new String[]{s});
            }
        }
    }
}

