/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.api.controller;

import com.biz.eisp.api.feign.TmOrgFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.dict.service.KnlDictDataService;
import com.biz.eisp.base.notice.service.KnlNoticeService;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.notice.entity.KnlNoticeEntity;
import com.biz.eisp.notice.vo.KnlNoticeVo;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@Api(tags={"KERNEL\u57fa\u7840\u529f\u80fd"}, description="CRM-BASE KERNEL\u516c\u544a\u7ba1\u7406")
@RestController
@RequestMapping(value={"/kernel-api/knlApiNoticeController"})
public class KnlApiNoticeController {
    @Autowired
    private KnlNoticeService knlNoticeService;
    @Autowired
    private KnlDictDataService knlDictDataService;
    @Autowired
    private TmOrgFeign tmOrgFeign;

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u516c\u544a\u5217\u8868", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u516c\u544a\u5217\u8868,\u8fd4\u56de\u503c\u5728objList", httpMethod="POST")
    @PostMapping(value={"getKnlNoticeList"})
    public DataGrid getKnlNoticeList(KnlNoticeVo vo, String page, String rows) {
        UserRedis userRedis = UserUtils.getUser();
        List tmOrgVos = this.tmOrgFeign.getOrgListByUser(userRedis.getId(), null).getObjList();
        tmOrgVos = tmOrgVos == null ? new ArrayList() : tmOrgVos;
        List<String> orgCodeList = tmOrgVos.stream().map(TmOrgVo::getOrgCode).distinct().collect(Collectors.toList());
        orgCodeList.add("ALL_ORG");
        Page pageObj = new Page(page, rows);
        PageInfo<KnlNoticeVo> knlNoticeVos = this.knlNoticeService.findKnlNoticeList(vo, orgCodeList, pageObj);
        Example example = new Example(KnlDictDataEntity.class);
        Example.Criteria criteria_ = example.createCriteria();
        criteria_.andEqualTo("dictTypeCode", (Object)"notice_type");
        List dataEntities = this.knlDictDataService.selectExample(example);
        for (KnlNoticeVo noticeVo : knlNoticeVos.getList()) {
            for (KnlDictDataEntity knlDictDataEntity : dataEntities) {
                if (!noticeVo.getNoticeType().equals(knlDictDataEntity.getDictCode())) continue;
                noticeVo.setNoticeTypeStr(knlDictDataEntity.getDictValue());
            }
        }
        return new DataGrid(knlNoticeVos);
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u516c\u544a\u5217\u8868", notes="\u67e5\u8be2\u516c\u544a\u7ba1\u7406\u5217\u8868,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"getKnlNoticeByPage"})
    public AjaxJson<KnlNoticeEntity> getKnlNoticeByPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<KnlNoticeEntity> knlNoticeEntityPageInfo = this.knlNoticeService.getKnlNoticePage(param, page);
        ajaxJson.setPageInfo(knlNoticeEntityPageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u516c\u544a\u8be6\u60c5", notes="\u67e5\u8be2\u516c\u544a\u8be6\u60c5,\u8fd4\u56de\u503c\u5728obj", httpMethod="POST")
    @PostMapping(value={"getKnlNoticeByParamObj"})
    public AjaxJson<KnlNoticeEntity> getKnlNoticeByParamObj(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlNoticeEntity entity = this.knlNoticeService.getKnlNoticeEntity(id);
        if (entity == null) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e\uff01");
            return ajaxJson;
        }
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }
}

