/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.configure.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.configure.service.KnlTableConfigService;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.configure.entity.KnlTableConfigEntity;
import com.biz.eisp.configure.vo.KnlTableConfigVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.tk.utils.BeanCopyUtils;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"/knlTableConfigController"})
public class KnlTableConfigController {
    @Autowired
    private KnlTableConfigService knlTableConfigService;

    @RequestMapping(value={"findKnlTableConfigPage"})
    public DataGrid findKnlTableConfigPage(HttpServletRequest request, KnlTableConfigVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<KnlTableConfigVo> knlTableConfigVoPageInfo = this.knlTableConfigService.findKnlTableConfigPage(vo, (Page)page);
        if (knlTableConfigVoPageInfo != null) {
            return new DataGrid(knlTableConfigVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @GetMapping(value={"findKnlTableConfigsByFuncId"})
    public AjaxJson<KnlTableConfigVo> findKnlTableConfigsByFuncId(String functionId) {
        AjaxJson j = new AjaxJson();
        if (StringUtils.isBlank((CharSequence)functionId)) {
            j.setObjList((List)Lists.newArrayList());
            return j;
        }
        Example param = new Example(KnlTableConfigEntity.class);
        Example.Criteria builder = param.createCriteria();
        builder.andEqualTo("functionId", (Object)functionId);
        builder.andEqualTo("isHide", (Object)ConstantEnum.YesNoEnum.ZERO.getValue());
        param.orderBy("showOrder").asc();
        j.setObjList(BeanCopyUtils.copyToBeanList((List)this.knlTableConfigService.selectExample(param), KnlTableConfigVo.class));
        return j;
    }

    @RequestMapping(value={"saveOrUpdate"})
    public AjaxJson saveOrUpdate(KnlTableConfigVo vo) {
        AjaxJson j = new AjaxJson();
        if ("group".equals(vo.getQueryMode()) && !"date".equals(vo.getFormType())) {
            return AjaxJson.failure((boolean)false, (String)"\u65f6\u95f4\u533a\u95f4\u53ea\u80fd\u662f\u65e5\u671f\u7c7b\u578b");
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.knlTableConfigService.update(vo);
            } else {
                this.knlTableConfigService.save(vo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(value={"deleteTableConfig"})
    public AjaxJson deleteTableConfig(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlTableConfigService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }
}

