/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.postman.request.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.HttpUtils;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.postman.request.dao.KnlPostRequestDao;
import com.biz.eisp.base.postman.request.dao.KnlRequestRecordDao;
import com.biz.eisp.base.postman.request.service.KnlPostRequestService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.postman.request.entity.KnlPostRequestEntity;
import com.biz.eisp.postman.request.entity.KnlRequestRecordEntity;
import com.biz.eisp.postman.request.vo.KnlPostRequestVo;
import com.biz.eisp.postman.request.vo.KnlRequestRecordVo;
import com.biz.eisp.postman.request.vo.RequestParamVo;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="knlPostRequestService")
@Transactional
public class KnlPostRequestServiceImplImpl
extends BaseServiceImpl<KnlPostRequestEntity>
implements KnlPostRequestService {
    @Autowired
    private KnlPostRequestDao knlPostRequestDao;
    @Autowired
    private KnlRequestRecordDao knlRequestRecordDao;

    @Override
    public List<KnlPostRequestEntity> findKnlPostRequestList(KnlPostRequestVo vo) {
        Example example = new Example(KnlPostRequestEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getRequestType())) {
            criteria.andEqualTo("requestType", (Object)vo.getRequestType());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getEnableStatus())) {
            criteria.andEqualTo("enableStatus", (Object)vo.getEnableStatus());
        }
        return this.knlPostRequestDao.selectByExample(example);
    }

    @Override
    public PageInfo<KnlPostRequestVo> findKnlPostRequestPage(KnlPostRequestVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.findKnlPostRequestList(vo), (Page)page);
    }

    @Override
    public KnlPostRequestEntity getKnlPostRequestEntity(String id) {
        return (KnlPostRequestEntity)this.knlPostRequestDao.selectByPrimaryKey(id);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=KnlPostRequestServiceImplImpl.class)
    public String save(KnlPostRequestVo vo) throws Exception {
        KnlPostRequestEntity entity = new KnlPostRequestEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.insertSelective(entity);
        }
        return entity.getId();
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=KnlPostRequestServiceImplImpl.class)
    public String update(KnlPostRequestVo vo) throws Exception {
        KnlPostRequestEntity entity = new KnlPostRequestEntity();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (KnlPostRequestEntity)this.knlPostRequestDao.selectByPrimaryKey(vo.getId());
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.updateByPrimaryKeySelective(entity);
        }
        return entity.getId();
    }

    @Override
    public List<KnlPostRequestEntity> getKnlPostRequestEntity(KnlPostRequestVo vo) throws Exception {
        Example inexample = new Example(KnlPostRequestEntity.class);
        Example.Criteria criteria = inexample.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            criteria.andNotEqualTo("id", (Object)vo.getId());
        }
        return this.knlPostRequestDao.selectByExample(inexample);
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=KnlPostRequestServiceImplImpl.class)
    public boolean delete(String id) {
        int i = this.knlPostRequestDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public AjaxJson sendPostHttp(KnlPostRequestVo vo) throws Exception {
        long startTime = System.currentTimeMillis();
        AjaxJson ajaxJson = new AjaxJson();
        String url = vo.getRequestUrl();
        String params = vo.getParams();
        String headers = vo.getHeaders();
        List requestParamVos = JSONArray.parseArray((String)headers, RequestParamVo.class);
        ArrayList<Header> headerList = new ArrayList<Header>();
        for (RequestParamVo requestParamVo : requestParamVos) {
            Header header = new Header();
            header.setName(requestParamVo.getKey());
            if (StringUtil.isNotEmpty((CharSequence)requestParamVo.getExtra())) {
                AjaxJson j = HttpUtils.sendRequest((String)requestParamVo.getExtra(), null, (String)"UTF-8", (int)10000);
                if (j.isSuccess()) {
                    requestParamVo.setValue(String.valueOf(j.getObj()));
                } else {
                    requestParamVo.setValue(j.getMsg());
                }
            }
            header.setValue(requestParamVo.getValue());
            headerList.add(header);
        }
        String body = vo.getBody();
        String extendParams = vo.getExtendParams();
        List paramsVos = new ArrayList();
        NameValuePair[] paramsList = null;
        if (body.equals("x-www-form-urlencoded")) {
            paramsVos = JSONArray.parseArray((String)params, RequestParamVo.class);
            for (RequestParamVo requestParamVo : paramsVos) {
                if (!StringUtil.isNotEmpty((CharSequence)requestParamVo.getExtra())) continue;
                AjaxJson j = HttpUtils.sendRequest((String)requestParamVo.getExtra(), null, (String)"UTF-8", (int)10000);
                if (j.isSuccess()) {
                    requestParamVo.setValue(String.valueOf(j.getObj()));
                    continue;
                }
                requestParamVo.setValue(j.getMsg());
            }
            int size = paramsVos.size();
            int i = 0;
            paramsList = new NameValuePair[size];
            for (i = 0; i < size; ++i) {
                NameValuePair nameValuePair = new NameValuePair();
                nameValuePair.setName(((RequestParamVo)paramsVos.get(i)).getKey());
                nameValuePair.setValue(((RequestParamVo)paramsVos.get(i)).getValue());
                paramsList[i] = nameValuePair;
            }
        } else if (vo.getBody().equals("raw") && StringUtil.isNotEmpty((CharSequence)vo.getExtendParams())) {
            AjaxJson j = HttpUtils.sendRequest((String)vo.getExtendParams(), null, (String)"UTF-8", (int)10000);
            if (j.isSuccess()) {
                vo.setParams(String.valueOf(j.getObj()));
            } else {
                vo.setParams(j.getMsg());
            }
        }
        ajaxJson = HttpUtils.sendHttpRequest((String)url, headerList, (String)params, paramsList, (String)body, (String)"UTF-8", (int)10000);
        long endTime = System.currentTimeMillis();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            KnlRequestRecordVo knlRequestRecordVo = new KnlRequestRecordVo();
            KnlRequestRecordEntity entity = new KnlRequestRecordEntity();
            long requestTime = endTime - startTime;
            knlRequestRecordVo.setRequestTime(String.valueOf(requestTime));
            knlRequestRecordVo.setHeadId(vo.getId());
            if (ajaxJson.isSuccess()) {
                knlRequestRecordVo.setIsSuccess("1");
            } else {
                knlRequestRecordVo.setIsSuccess("0");
                knlRequestRecordVo.setFaildMsg(ajaxJson.getMsg());
            }
            MyBeanUtils.copyBeanNotNull2Bean((Object)knlRequestRecordVo, (Object)entity);
            this.knlRequestRecordDao.insertSelective(entity);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson startOrStop(KnlPostRequestVo knlPostRequestVo) {
        AjaxJson j = new AjaxJson();
        KnlPostRequestEntity knlPostRequestEntity = (KnlPostRequestEntity)this.knlPostRequestDao.selectByPrimaryKey(knlPostRequestVo.getId());
        if (StringUtil.isNotEmpty((Object)knlPostRequestEntity)) {
            if (knlPostRequestEntity.getEnableStatus().toString().equals(knlPostRequestVo.getEnableStatus().toString())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.equals(knlPostRequestVo.getEnableStatus()) ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                knlPostRequestEntity.setEnableStatus(knlPostRequestVo.getEnableStatus());
                this.knlPostRequestDao.updateByPrimaryKeySelective(knlPostRequestEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }
}

