/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.api.controller;

import com.biz.eisp.base.code.service.KnlCodingInitService;
import com.biz.eisp.base.code.service.KnlCodingRulesService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.code.entity.KnlCodingRulesEntity;
import com.biz.eisp.code.vo.KnlCodingRulesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.klock.annotation.Klock;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@Api(tags={"KERNEL\u57fa\u7840\u529f\u80fd"}, description="CRM-BASE KERNEL\u7f16\u7801\u89c4\u5219")
@RestController
@RequestMapping(value={"/kernel-api/knlApiCodeRuleController"})
public class KnlApiCodeRuleController {
    @Autowired
    private KnlCodingRulesService knlCodingRulesService;
    @Autowired
    private KnlCodingInitService knlCodingInitService;

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7f16\u7801\u89c4\u5219", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7f16\u7801\u89c4\u5219,\u8fd4\u56de\u503c\u5728obj", httpMethod="POST")
    @PostMapping(value={"getCodeRuleObj"})
    public AjaxJson<KnlCodingRulesEntity> getCodeRuleObj(@RequestParam(value="codingRuleCode") String codingRuleCode) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(KnlCodingRulesEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)codingRuleCode)) {
            criteria.andEqualTo("codingRuleCode", (Object)codingRuleCode);
        } else {
            criteria.andIsNull("codingRuleCode");
        }
        List knlCodingRulesEntities = this.knlCodingRulesService.selectExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)knlCodingRulesEntities)) {
            this.knlCodingInitService.initCodeRule(knlCodingRulesEntities);
            ajaxJson.setObj(knlCodingRulesEntities.get(0));
        } else {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636ekey\u4fee\u6539\u7f16\u7801\u89c4\u5219", notes="\u6839\u636ekey\u4fee\u6539\u7f16\u7801\u89c4\u5219,\u8fd4\u56de\u503c\u5728boolean", httpMethod="POST")
    @PostMapping(value={"updateCodeRuleObj"})
    public AjaxJson<KnlCodingRulesEntity> updateCodeRuleObj(@RequestParam(value="codingRuleCode") String codingRuleCode, @RequestParam(value="currentValue") Integer currentValue) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlCodingRulesVo vo = new KnlCodingRulesVo();
        vo.setCodingRuleCode(codingRuleCode);
        vo.setCurrentValue(currentValue);
        boolean rs = this.knlCodingRulesService.updateCodeRuleByCode(vo);
        if (!rs) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxJson;
    }

    @ApiOperation(value="\u751f\u6210\u7f16\u7801list", notes="\u751f\u6210\u7f16\u7801list,\u8fd4\u56de\u503c\u5728objList", httpMethod="POST")
    @PostMapping(value={"getCodeRuleList"})
    @Klock(keys={"#codingRuleCode"})
    public AjaxJson<String> getCodeRuleList(@RequestParam(value="codingRuleCode") String codingRuleCode, @RequestParam(value="number") Integer number) {
        List knlCodingRulesEntities;
        ArrayList<String> strings = new ArrayList<String>();
        AjaxJson ajaxJson = new AjaxJson();
        KnlCodingRulesEntity entity = new KnlCodingRulesEntity();
        Example example = new Example(KnlCodingRulesEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)codingRuleCode)) {
            criteria.andEqualTo("codingRuleCode", (Object)codingRuleCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(knlCodingRulesEntities = this.knlCodingRulesService.selectExample(example)))) {
            entity = (KnlCodingRulesEntity)knlCodingRulesEntities.get(0);
        }
        String prefix = entity.getPrefix();
        String dateStr = entity.getDateStr();
        int codeLength = entity.getCodeLength();
        int initialValue = entity.getInitialValue();
        int currentValue = 0;
        currentValue = StringUtil.isEmpty((Object)entity.getCurrentValue()) ? initialValue : entity.getCurrentValue();
        int newCurrenValue = currentValue + number;
        KnlCodingRulesVo vo = new KnlCodingRulesVo();
        vo.setCodingRuleCode(codingRuleCode);
        vo.setGenerationTime(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        vo.setCurrentValue(Integer.valueOf(newCurrenValue));
        this.knlCodingRulesService.updateCodeRuleByCode(vo);
        for (int i = 0; i < number; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(prefix);
            if (StringUtil.isNotEmpty((CharSequence)dateStr)) {
                stringBuffer.append(DateUtils.format((Date)new Date(), (String)dateStr));
            }
            int plength = prefix.length() + String.valueOf(++currentValue).length();
            int fillLength = codeLength - plength;
            for (int j = 0; j < fillLength; ++j) {
                stringBuffer.append("0");
            }
            stringBuffer.append(currentValue);
            strings.add(stringBuffer.toString());
        }
        ajaxJson.setObjList(strings);
        return ajaxJson;
    }

    @ApiOperation(value="\u91cd\u7f6e\u5f53\u524d\u503c\u4e3a0", notes="\u91cd\u7f6e\u5f53\u524d\u503c\u4e3a0,\u8fd4\u56de\u503c\u5728boolean", httpMethod="POST")
    @PostMapping(value={"resetCurrentValue"})
    public AjaxJson<KnlCodingRulesEntity> resetCurrentValue(@RequestParam(value="codingRuleCode") String codingRuleCode) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlCodingRulesVo vo = new KnlCodingRulesVo();
        vo.setCodingRuleCode(codingRuleCode);
        List<KnlCodingRulesEntity> entities = this.knlCodingRulesService.getKnlCodingRulesEntity(vo);
        KnlCodingRulesEntity entity = null;
        if (CollectionUtil.listNotEmptyNotSizeZero(entities)) {
            entity = entities.get(0);
            vo.setId(entity.getId());
            vo.setCurrentValue(Integer.valueOf(0));
        }
        if (!this.knlCodingRulesService.resetCurrentValue(vo)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u91cd\u7f6e\u5931\u8d25");
        }
        return ajaxJson;
    }

    @GetMapping(value={"getKnlCodingRulesEntity"})
    public AjaxJson<KnlCodingRulesEntity> getKnlCodingRulesEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlCodingRulesEntity entity = this.knlCodingRulesService.getKnlCodingRulesEntity(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }
}

