/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.code.service.impl;

import com.biz.eisp.base.code.dao.KnlCodingRulesDao;
import com.biz.eisp.base.code.service.KnlCodingInitService;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.code.entity.KnlCodingRulesEntity;
import com.biz.eisp.service.RedisService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="knlCodingInitService")
public class KnlCodingInitServiceImpl
implements KnlCodingInitService {
    @Autowired
    private KnlCodingRulesDao knlCodingRulesDao;
    @Autowired
    private RedisService redisService;

    @Override
    public void initCodingRulesToRedis() {
        List entitys = this.knlCodingRulesDao.selectAll();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entitys)) {
            entitys.forEach(entity -> {
                this.redisService.setDays("CODE_RULE_" + entity.getCodingRuleCode(), entity, 3650L);
                this.redisService.incr("CODE_RULE_INIT_" + entity.getCodingRuleCode(), (long)Integer.valueOf(entity.getInitialValue()).intValue());
            });
        }
    }

    @Override
    public void initCodeRule(List<KnlCodingRulesEntity> knlCodingRulesEntities) {
        if (CollectionUtil.listNotEmptyNotSizeZero(knlCodingRulesEntities)) {
            knlCodingRulesEntities.forEach(dataItem -> {
                this.redisService.setDays("CODE_RULE_" + dataItem.getCodingRuleCode(), dataItem, 3650L);
                this.redisService.incr("CODE_RULE_INIT_" + dataItem.getCodingRuleCode(), (long)Integer.valueOf(dataItem.getInitialValue()).intValue());
            });
        }
    }
}

