/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.configure.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.configure.dao.KnlTableConfigDao;
import com.biz.eisp.base.configure.service.KnlTableConfigService;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.configure.entity.KnlTableConfigEntity;
import com.biz.eisp.configure.vo.KnlTableConfigVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="knlTableConfigService")
@Transactional
public class KnlTableConfigServiceImplImpl
extends BaseServiceImpl<KnlTableConfigEntity>
implements KnlTableConfigService {
    @Autowired
    private KnlTableConfigDao knlTableConfigDao;
    @Autowired
    private RedisService redisService;

    @Override
    public List<KnlTableConfigVo> findKnlTableConfigList(KnlTableConfigVo vo) {
        return this.knlTableConfigDao.findKnlTableConfigList(vo);
    }

    @Override
    public PageInfo<KnlTableConfigVo> findKnlTableConfigPage(KnlTableConfigVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.knlTableConfigDao.findKnlTableConfigList(vo), (Page)page);
    }

    @Override
    public KnlTableConfigEntity getKnlTableConfigEntity(String id) {
        return (KnlTableConfigEntity)this.knlTableConfigDao.selectByPrimaryKey(id);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=KnlTableConfigServiceImplImpl.class)
    public void save(KnlTableConfigVo vo) throws Exception {
        KnlTableConfigEntity entity = new KnlTableConfigEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            entity = this.getEntity(entity, vo);
            this.insertSelective(entity);
        }
        this.redisService.hset("TABLE_CONFIG_" + entity.getFunctionId(), entity.getField(), (Object)entity);
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=KnlTableConfigServiceImplImpl.class)
    public void update(KnlTableConfigVo vo) throws Exception {
        KnlTableConfigEntity entity = new KnlTableConfigEntity();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (KnlTableConfigEntity)this.knlTableConfigDao.selectByPrimaryKey(vo.getId());
            if (entity != null && !Objects.equals(entity.getField(), vo.getField())) {
                this.redisService.hdel("TABLE_CONFIG_" + entity.getFunctionId(), new Object[]{entity.getField()});
            }
            entity = this.getEntity(entity, vo);
            this.updateByPrimaryKeySelective(entity);
        }
        this.redisService.hset("TABLE_CONFIG_" + entity.getFunctionId(), entity.getField(), (Object)entity);
    }

    private KnlTableConfigEntity getEntity(KnlTableConfigEntity entity, KnlTableConfigVo vo) {
        entity.setIsSearch(vo.getIsSearch());
        entity.setShowOrder(Integer.valueOf(vo.getShowOrder()));
        entity.setIsHide(vo.getIsHide());
        entity.setField(vo.getField());
        entity.setFunctionId(vo.getFunctionId());
        entity.setId(vo.getId());
        entity.setDictionary(vo.getDictionary());
        entity.setIsExcel(vo.getIsExcel());
        entity.setShowWidth(vo.getShowWidth());
        entity.setStatus(vo.getStatus());
        entity.setTableTags(vo.getTableTags());
        entity.setTitle(vo.getTitle());
        entity.setQueryMode(vo.getQueryMode());
        entity.setFormType(vo.getFormType());
        entity.setFormatter(vo.getFormatter());
        return entity;
    }

    @Override
    public List<KnlTableConfigEntity> getKnlTableConfigEntity(KnlTableConfigVo vo) throws Exception {
        Example inexample = new Example(KnlTableConfigEntity.class);
        Example.Criteria criteria = inexample.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            criteria.andNotEqualTo("id", (Object)vo.getId());
        }
        return this.knlTableConfigDao.selectByExample(inexample);
    }

    @Override
    public List<KnlTableConfigEntity> getEnableConfigByFuncid(String funcid) {
        if (StringUtil.isBlank((CharSequence)funcid)) {
            return Lists.newArrayList();
        }
        Example inexample = new Example(KnlTableConfigEntity.class);
        Example.Criteria criteria = inexample.createCriteria();
        criteria.andEqualTo("functionId", (Object)funcid);
        criteria.andEqualTo("isHide", (Object)ConstantEnum.YesNoEnum.ZERO.getValue());
        inexample.orderBy("showOrder").asc();
        return this.knlTableConfigDao.selectByExample(inexample);
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=KnlTableConfigServiceImplImpl.class)
    public boolean delete(String id) {
        KnlTableConfigEntity tableEntity = (KnlTableConfigEntity)this.knlTableConfigDao.selectByPrimaryKey(id);
        int i = this.knlTableConfigDao.deleteByPrimaryKey(id);
        if (i > 0) {
            this.redisService.hdel("TABLE_CONFIG_" + tableEntity.getFunctionId(), new Object[]{tableEntity.getField()});
            return true;
        }
        return false;
    }

    @Override
    public void restSave(String functionId, String userName) {
        Example example = new Example(KnlTableConfigEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("functionId", (Object)functionId);
        criteria.andEqualTo("userName", (Object)userName);
        this.knlTableConfigDao.deleteByExample(example);
        this.redisService.del(new String[]{"TABLE_CONFIG_" + userName + "_" + functionId});
    }
}

