/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.configure.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.configure.controller.FuncIdBuilder;
import com.biz.eisp.base.configure.service.KnlFormConfigService;
import com.biz.eisp.base.configure.service.KnlTableConfigService;
import com.biz.eisp.configure.entity.KnlFormConfigEntity;
import com.biz.eisp.configure.entity.KnlTableConfigEntity;
import com.biz.eisp.configure.vo.FormTableVo;
import com.biz.eisp.configure.vo.KnlFormConfigVo;
import com.biz.eisp.configure.vo.KnlTableConfigVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.tk.utils.BeanCopyUtils;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u9875\u9762\u83dc\u5355\u914d\u7f6e", tags={"\u9875\u9762\u83dc\u5355\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/knlFormConfigController"})
public class KnlFormConfigController {
    private static final Logger log = LoggerFactory.getLogger(KnlFormConfigController.class);
    @Autowired
    private KnlFormConfigService knlFormConfigService;
    @Autowired
    private KnlTableConfigService knlTableConfigService;

    @RequestMapping(value={"findKnlFormConfigPage"})
    public DataGrid findKnlFormConfigPage(HttpServletRequest request, KnlFormConfigVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<KnlFormConfigVo> knlFormConfigVoPageInfo = this.knlFormConfigService.findKnlFormConfigPage(vo, (Page)page);
        if (knlFormConfigVoPageInfo != null) {
            return new DataGrid(knlFormConfigVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @ApiOperation(value="\u6839\u636efunction id \u67e5\u8be2 \u542f\u7528\u7684\u914d\u7f6e")
    @GetMapping(value={"getEnableConfigByFuncid"})
    public AjaxJson<FormTableVo> getEnableConfigByFuncid(String funcid, String bizType) {
        AjaxJson data = new AjaxJson();
        List<KnlFormConfigEntity> entitys = this.knlFormConfigService.getEnableConfigByFuncid(funcid);
        FormTableVo dataVo = new FormTableVo();
        dataVo.setFormConfig(BeanCopyUtils.copyToBeanList(entitys, KnlFormConfigVo.class));
        data.setObj((Object)dataVo);
        if (StringUtil.isNotBlank((CharSequence)bizType)) {
            List<KnlTableConfigEntity> tableConfigs = this.knlTableConfigService.getEnableConfigByFuncid(FuncIdBuilder.buildFuncId(funcid, bizType));
            dataVo.setTableConfig(BeanCopyUtils.copyToBeanList(tableConfigs, KnlTableConfigVo.class));
        } else {
            dataVo.setTableConfig((List)Lists.newArrayList());
        }
        return data;
    }

    @RequestMapping(value={"saveOrUpdate"})
    public AjaxJson saveOrUpdate(KnlFormConfigVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getFunctionId())) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            this.knlFormConfigService.update(vo);
        } else {
            this.knlFormConfigService.save(vo);
        }
        return ajaxJson;
    }

    @RequestMapping(value={"deleteFormConfig"})
    public AjaxJson deleteFormConfig(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlFormConfigService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"validateFormTags"})
    public ValidForm validateFormTags(HttpServletRequest request, String id) {
        String param = OConvertUtils.getString((String)request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        try {
            KnlFormConfigVo vo = new KnlFormConfigVo();
            vo.setFormTags(param);
            vo.setId(id);
            List<KnlFormConfigEntity> list = this.knlFormConfigService.getKnlFormConfigEntity(vo);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                validForm.setStatus("n");
                validForm.setInfo("\u6807\u7b7e\u5df2\u5b58\u5728");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return validForm;
    }
}

