/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.dict.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.dict.service.KnlDictTypeService;
import com.biz.eisp.dict.entity.KnlDictTypeEntity;
import com.biz.eisp.dict.vo.KnlDictTypeVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/knlDictTypeController"})
public class KnlDictTypeController {
    private static final Logger log = LoggerFactory.getLogger(KnlDictTypeController.class);
    @Autowired
    private KnlDictTypeService knlDictTypeService;

    @RequestMapping(value={"findKnlDictTypePage"})
    public DataGrid findKnlDictTypePage(HttpServletRequest request, KnlDictTypeVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<KnlDictTypeVo> knlDictTypeVoPageInfo = this.knlDictTypeService.findKnlDictTypePage(vo, (Page)page);
        if (knlDictTypeVoPageInfo != null) {
            return new DataGrid(knlDictTypeVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"saveOrUpdate"})
    public AjaxJson saveOrUpdate(KnlDictTypeVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.knlDictTypeService.update(vo);
            } else {
                this.knlDictTypeService.save(vo);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return j;
    }

    @RequestMapping(value={"validateTypeCode"})
    public ValidForm validateTypeCode(HttpServletRequest request, String id) {
        String param = OConvertUtils.getString((String)request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        try {
            KnlDictTypeVo vo = new KnlDictTypeVo();
            vo.setDictTypeCode(param);
            vo.setId(id);
            List<KnlDictTypeEntity> list = this.knlDictTypeService.getKnlDictTypeEntity(vo);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                validForm.setStatus("n");
                validForm.setInfo("\u6570\u636e\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return validForm;
    }

    @RequestMapping(value={"deleteDictType"})
    public AjaxJson deleteDictType(String id) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlDictTypeService.delete(id)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @GetMapping(value={"getKnlDictTypeEntity"})
    @ResponseBody
    public AjaxJson<KnlDictTypeEntity> getKnlDictTypeEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlDictTypeEntity knlCacheViewVo = this.knlDictTypeService.getKnlDictTypeEntity(id);
        ajaxJson.setObj((Object)knlCacheViewVo);
        return ajaxJson;
    }
}

