/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.parameter.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.parameter.service.KnlParameterManageService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.parameter.entity.KnlParameterManageEntity;
import com.biz.eisp.parameter.vo.KnlParameterManageVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/knlParameterManageController"})
public class KnlParameterManageController {
    private static final Logger log = LoggerFactory.getLogger(KnlParameterManageController.class);
    @Autowired
    private KnlParameterManageService knlParameterManageService;

    @RequestMapping(value={"goKnlParameterManageMain"})
    public ModelAndView goKnlParameterManageMain() {
        return new ModelAndView("com/biz/eisp/parameter/parameterManageMain");
    }

    @RequestMapping(value={"findKnlParameterManagePage"})
    @ResponseBody
    public DataGrid findKnlParameterManagePage(HttpServletRequest request, KnlParameterManageVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<KnlParameterManageVo> knlParameterManageVoPageInfo = this.knlParameterManageService.findKnlParameterManagePage(vo, (Page)page);
        if (knlParameterManageVoPageInfo != null) {
            return new DataGrid(knlParameterManageVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"goSaveOrUpdateParameterManage"})
    public ModelAndView goSaveOrUpdateParameterManage(HttpServletRequest request, KnlParameterManageVo vo) {
        if (vo != null && StringUtils.isNotBlank((CharSequence)vo.getId())) {
            KnlParameterManageEntity entity = this.knlParameterManageService.getKnlParameterManageEntity(vo.getId(), null);
            request.setAttribute("vo", (Object)entity);
        }
        return new ModelAndView("com/biz/eisp/parameter/parameterManageForm");
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(KnlParameterManageVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.knlParameterManageService.update(vo);
            } else {
                this.knlParameterManageService.save(vo);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"deleteParameterManage"})
    public AjaxJson deleteParameterManage(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlParameterManageService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }
}

