/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.icon.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.icon.service.KnlIconManageService;
import com.biz.eisp.icon.vo.KnlIconManageVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/knlIconManageController"})
public class KnlIconManageController {
    @Autowired
    private KnlIconManageService knlIconManageService;

    @RequestMapping(value={"goKnlIconManageMain"})
    public ModelAndView goKnlIconManageMain() {
        return new ModelAndView("com/biz/eisp/icon/iconManageMain");
    }

    @RequestMapping(value={"findKnlIconManagePage"})
    @ResponseBody
    public DataGrid findKnlIconManagePage(HttpServletRequest request, KnlIconManageVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<KnlIconManageVo> knlIconManageVoPageInfo = this.knlIconManageService.findKnlIconManagePage(vo, (Page)page);
        if (knlIconManageVoPageInfo != null) {
            return new DataGrid(knlIconManageVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"goSaveOrUpdateIconManage"})
    public ModelAndView goSaveOrUpdateIconManage(HttpServletRequest request, KnlIconManageVo vo) {
        if (vo != null && StringUtils.isNotBlank((CharSequence)vo.getId())) {
            KnlIconManageVo icon = this.knlIconManageService.getKnlIconManageVo(vo.getId());
            request.setAttribute("vo", (Object)icon);
        }
        return new ModelAndView("com/biz/eisp/icon/iconManageForm");
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(KnlIconManageVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.knlIconManageService.update(vo);
            } else {
                this.knlIconManageService.save(vo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"deleteIconManage"})
    public AjaxJson deleteIconManage(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlIconManageService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @GetMapping(value={"getKnlIconManageVo"})
    public AjaxJson<KnlIconManageVo> getKnlIconManageVo(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlIconManageVo vo = this.knlIconManageService.getKnlIconManageVo(id);
        ajaxJson.setObj((Object)vo);
        return ajaxJson;
    }
}

