/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.api.controller;

import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.config.entity.TtBudgetSubjectsEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.TtBudgetSubjectsService;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesService;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.budget.fee.service.TtFeeBudgetService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import tk.mybatis.mapper.entity.Example;

@RequestMapping(value={"/ttApiFineController"})
@Controller
public class TtApiFineController {
    @Autowired
    private TtCostTypeFineService ttCostTypeFineService;
    @Autowired
    private TtFeeBudgetService ttFeeBudgetService;
    @Autowired
    private TtBudgetSubjectsService ttBudgetSubjectsService;
    @Autowired
    private TtCostTypeCategoriesService ttCostTypeCategoriesService;

    @RequestMapping(value={"getActFineList"})
    @ResponseBody
    public List<TtCostTypeFineEntity> getActFineList(HttpServletRequest request, TtCostTypeFineEntity ttCostTypeFineEntity, String budgetCode) {
        String orgCode = UserUtils.getUser().getOrgCode();
        TtFeeBudgetEntity entity = this.ttFeeBudgetService.getEntity(null, budgetCode);
        ArrayList<TtCostTypeFineEntity> entities = new ArrayList<TtCostTypeFineEntity>();
        if (entity != null) {
            TtBudgetSubjectsEntity ttBudgetSubjectsEntity = this.ttBudgetSubjectsService.getEntity(null, entity.getBudgetSubjectsCode());
            Example example = new Example(TtCostTypeCategoriesEntity.class);
            Example.Criteria criteria = example.createCriteria();
            if (StringUtil.isNotEmpty((CharSequence)ttBudgetSubjectsEntity.getBudgetSubjectsCode())) {
                criteria.andEqualTo("budgetSubjectsCode", (Object)ttBudgetSubjectsEntity.getBudgetSubjectsCode());
            }
            criteria.andCondition("  EXISTS ( select id from tt_cost_type_fine_detail where  fine_code = categories_code and code = '" + orgCode + "' ) ");
            List ttCostTypeCategoriesEntities = this.ttCostTypeCategoriesService.selectExample(example);
            ttCostTypeCategoriesEntities.forEach(item -> {
                Example example1 = new Example(TtCostTypeFineEntity.class);
                Example.Criteria criteria1 = example1.createCriteria();
                if (ttCostTypeFineEntity.getTableType().equals(ConstantEnum.TableTypeEnum.ACT_PRICE.getValue())) {
                    criteria1.andEqualTo("actMethodCode", (Object)ConstantEnum.ActMethodEnum.SDFY.getValue());
                }
                if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getTableType())) {
                    criteria1.andLike("tableType", "%" + ttCostTypeFineEntity.getTableType() + "%");
                }
                if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getCategoriesStatus())) {
                    criteria1.andEqualTo("categoriesStatus", (Object)ttCostTypeFineEntity.getCategoriesStatus());
                }
                if (StringUtil.isNotEmpty((CharSequence)item.getCategoriesCode())) {
                    criteria1.andEqualTo("categoriesCode", (Object)item.getCategoriesCode());
                }
                List ttCostTypeFineEntities = this.ttCostTypeFineService.selectExample(example1);
                ttCostTypeFineEntities.forEach(detail -> entities.add((TtCostTypeFineEntity)detail));
            });
        }
        return entities;
    }

    @RequestMapping(value={"getActFinesList"})
    @ResponseBody
    public DataGrid getActFinesList(HttpServletRequest request, TtCostTypeFineEntity ttCostTypeFineEntity, String budgetCodes) {
        EuPage page = new EuPage(request);
        String[] codesArr = budgetCodes.split(",");
        PageInfo<TtCostTypeFineEntity> pageInfo = this.ttCostTypeFineService.getActFinesList(ttCostTypeFineEntity, new ArrayList<String>(Arrays.asList(codesArr)), (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getActFinesListByCatge"})
    @ResponseBody
    public DataGrid getActFinesListByCatge(HttpServletRequest request, TtCostTypeFineEntity ttCostTypeFineEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtCostTypeFineEntity> pageInfo = this.ttCostTypeFineService.getActFinesListByCatge(ttCostTypeFineEntity, (Page)page);
        return new DataGrid(pageInfo);
    }
}

