/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.fee.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.vo.FeeUseBudgutParam;
import com.biz.eisp.budget.fee.dao.TtFeeBudgetDao;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.budget.fee.service.TtFeeBudgetService;
import com.biz.eisp.budget.fee.vo.AdjustAmountVo;
import com.biz.eisp.budget.used.entity.TtBudgutDetailEntity;
import com.biz.eisp.budget.used.service.TtBudgutDetailService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.surplus.Service.TtCustPostService;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttFeeBudgetService")
@Transactional
public class TtFeeBudgetServiceImpl
extends BaseServiceImpl<TtFeeBudgetEntity>
implements TtFeeBudgetService {
    @Autowired
    private TtFeeBudgetDao ttFeeBudgetDao;
    @Autowired
    private TtBudgutDetailService ttBudgutDetailService;
    @Autowired
    private TtCustPostService ttCustPostService;

    @Override
    public PageInfo<TtFeeBudgetEntity> getMaiList(TtFeeBudgetEntity ttFeeBudgetEntity, Page page) {
        Example example = new Example(TtFeeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getBudgetYear())) {
            criteria.andEqualTo("budgetYear", (Object)ttFeeBudgetEntity.getBudgetYear());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getBudgetMonth())) {
            criteria.andEqualTo("budgetMonth", (Object)ttFeeBudgetEntity.getBudgetMonth());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getBudgetCode())) {
            criteria.andLike("budgetCode", "%" + ttFeeBudgetEntity.getBudgetCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getBudgetName())) {
            criteria.andLike("budgetName", "%" + ttFeeBudgetEntity.getBudgetName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getBudgetSubjectsCode())) {
            criteria.andEqualTo("budgetSubjectsCode", (Object)ttFeeBudgetEntity.getBudgetSubjectsCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getBudgetSubjectsName())) {
            criteria.andLike("budgetSubjectsName", "%" + ttFeeBudgetEntity.getBudgetSubjectsName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getBudgetDepartName())) {
            criteria.andLike("budgetDepartName", "%" + ttFeeBudgetEntity.getBudgetDepartName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getVkorgCode())) {
            criteria.andEqualTo("vkorgCode", (Object)ttFeeBudgetEntity.getVkorgCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getProductName())) {
            criteria.andLike("productName", "%" + ttFeeBudgetEntity.getProductName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getCustName())) {
            criteria.andLike("custName", "%" + ttFeeBudgetEntity.getCustName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getTerminalName())) {
            criteria.andLike("terminalName", "%" + ttFeeBudgetEntity.getTerminalName() + "%");
        }
        if (StringUtil.isNotEmpty((Object)ttFeeBudgetEntity.getInitAmount())) {
            criteria.andEqualTo("initAmount", (Object)ttFeeBudgetEntity.getInitAmount());
        }
        if (StringUtil.isNotEmpty((Object)ttFeeBudgetEntity.getAmount())) {
            criteria.andEqualTo("amount", (Object)ttFeeBudgetEntity.getAmount());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getCreateName())) {
            criteria.andLike("createName", "%" + ttFeeBudgetEntity.getCreateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getUpdateName())) {
            criteria.andLike("updateName", "%" + ttFeeBudgetEntity.getUpdateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getExtChar1())) {
            criteria.andLike("extChar1", "%" + ttFeeBudgetEntity.getExtChar1() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getExtChar2())) {
            criteria.andLike("extChar2", "%" + ttFeeBudgetEntity.getExtChar2() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getExtChar3())) {
            criteria.andLike("extChar3", "%" + ttFeeBudgetEntity.getExtChar3() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getExtChar4())) {
            criteria.andLike("extChar4", "%" + ttFeeBudgetEntity.getExtChar4() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getExtChar5())) {
            criteria.andLike("extChar5", "%" + ttFeeBudgetEntity.getExtChar5() + "%");
        }
        criteria.andNotEqualTo("enableStatus", (Object)ConstantEnum.StatusEnum.DELETE.getValue());
        example.setOrderByClause(" subjects_group_code desc,budget_year desc , budget_month desc");
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.ttFeeBudgetDao.selectByExample(example), (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
            pageInfo.getList().forEach(item -> {
                BigDecimal additionalMoney = this.getMoney(ConstantEnum.BudgetUesdTypeEnum.ADDITIONAL.getValue(), item.getBudgetCode());
                BigDecimal cutoutMoney = this.getMoney(ConstantEnum.BudgetUesdTypeEnum.CUTOUT.getValue(), item.getBudgetCode());
                BigDecimal adjustImportMoney = this.getMoney(ConstantEnum.BudgetUesdTypeEnum.ADJUST_IMPORT.getValue(), item.getBudgetCode());
                BigDecimal adjustOutMoney = this.getMoney(ConstantEnum.BudgetUesdTypeEnum.ADJUST_OUT.getValue(), item.getBudgetCode());
                BigDecimal useMoney = this.getMoney(ConstantEnum.BudgetUesdTypeEnum.USE.getValue(), item.getBudgetCode());
                item.setAdditionalMoney(additionalMoney);
                item.setAdjustImportMoney(adjustImportMoney);
                item.setAdjustOutMoney(adjustOutMoney);
                item.setCutoutMoney(cutoutMoney);
                item.setUseMoney(useMoney);
            });
        }
        return pageInfo;
    }

    private BigDecimal getMoney(String typeCode, String budgetCode) {
        TtBudgutDetailEntity ttBudgutDetailEntity = new TtBudgutDetailEntity();
        ttBudgutDetailEntity.setBudgetCode(budgetCode);
        ttBudgutDetailEntity.setTypeCode(typeCode);
        List<TtBudgutDetailEntity> ttBudgutDetailEntities = this.ttBudgutDetailService.getMaiList(ttBudgutDetailEntity);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (TtBudgutDetailEntity entity : ttBudgutDetailEntities) {
            bigDecimal = bigDecimal.add(entity.getFeeAmount());
        }
        return bigDecimal;
    }

    @Override
    public TtFeeBudgetEntity getEntity(String id, String budgetCode) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)budgetCode)) {
            return null;
        }
        Example example = new Example(TtFeeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)budgetCode)) {
            criteria.andEqualTo("budgetCode", (Object)budgetCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttFeeBudgetDao.selectByExample(example)))) {
            return (TtFeeBudgetEntity)list.get(0);
        }
        return null;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtFeeBudgetServiceImpl.class)
    public AjaxJson update(TtFeeBudgetEntity entity, AjaxJson ajaxJson) {
        entity.setInitAmount(null);
        this.ttFeeBudgetDao.updateByPrimaryKeySelective(entity);
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson updateAmount(TtFeeBudgetEntity ttFeeBudgetEntity, AjaxJson ajaxJson) {
        if (ttFeeBudgetEntity.getAmountUpdate() == null) {
            ajaxJson.setErrMsg("\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
        feeUseBudgutParam.setBugetCode(ttFeeBudgetEntity.getBudgetCode());
        feeUseBudgutParam.setType(ttFeeBudgetEntity.getChangeType());
        feeUseBudgutParam.setAmount(ttFeeBudgetEntity.getAmountUpdate());
        feeUseBudgutParam.setNote(ttFeeBudgetEntity.getNotes());
        ajaxJson = this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam);
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(ttFeeBudgetEntity.getBudgetCode(), ttFeeBudgetEntity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtFeeBudgetServiceImpl.class)
    public AjaxJson save(TtFeeBudgetEntity entity, AjaxJson ajaxJson) {
        if (entity.getInitAmount() == null) {
            ajaxJson.setErrMsg("\u521d\u59cb\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        entity.setBudgetCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.fee_budget.name()));
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.ttFeeBudgetDao.insertSelective(entity);
        FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
        feeUseBudgutParam.setBugetCode(entity.getBudgetCode());
        feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.INIT.getValue());
        feeUseBudgutParam.setAmount(entity.getInitAmount());
        feeUseBudgutParam.setNote("\u65b0\u589e");
        this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam);
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson delete(String id, AjaxJson ajaxJson) {
        TtFeeBudgetEntity ttFeeBudgetEntity = (TtFeeBudgetEntity)this.ttFeeBudgetDao.selectByPrimaryKey(id);
        Example example = new Example(TtBudgutDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("budgetCode", (Object)ttFeeBudgetEntity.getBudgetCode());
        ArrayList<String> list = new ArrayList<String>();
        list.add(ConstantEnum.BudgetUesdTypeEnum.ADJUST_OUT.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.ADJUST_IMPORT.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.ADDITIONAL.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.CUTOUT.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.USE.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.BACK.getValue());
        criteria.andIn("typeCode", list);
        List ttBudgutDetailEntities = this.ttBudgutDetailService.selectExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)ttBudgutDetailEntities)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u9884\u7b97\u7f16\u53f7\u4e3a" + ttFeeBudgetEntity.getBudgetCode() + "\u7684\u8d39\u7528\u9884\u7b97\u5df2\u7ecf\u4ea7\u751f\u660e\u7ec6\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            return ajaxJson;
        }
        TtFeeBudgetEntity entity = new TtFeeBudgetEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
        entity.setId(id);
        this.ttFeeBudgetDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }

    @Override
    public List<TtFeeBudgetEntity> getEntityByCodes(List<String> budgetCodes) {
        Example example = new Example(TtFeeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("budgetCode", budgetCodes);
        return this.ttFeeBudgetDao.selectByExample(example);
    }

    @Override
    public AjaxJson adjustAmount(AdjustAmountVo adjustAmountVo, AjaxJson ajaxJson) {
        if (StringUtil.isEmpty((String)adjustAmountVo.getSrcId()) || StringUtil.isEmpty((String)adjustAmountVo.getTarId())) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        TtFeeBudgetEntity srcFeeBudgetEntity = this.getEntity(adjustAmountVo.getSrcId(), null);
        TtFeeBudgetEntity tarFeeBudgetEntity = this.getEntity(adjustAmountVo.getTarId(), null);
        FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
        feeUseBudgutParam.setBugetCode(srcFeeBudgetEntity.getBudgetCode());
        feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.ADJUST_OUT.getValue());
        feeUseBudgutParam.setAmount(adjustAmountVo.getAmountUpdate());
        feeUseBudgutParam.setNote(adjustAmountVo.getNotes());
        feeUseBudgutParam.setBusinessCode(tarFeeBudgetEntity.getBudgetCode());
        ajaxJson = this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        FeeUseBudgutParam feeUseBudgutParam1 = new FeeUseBudgutParam();
        feeUseBudgutParam1.setBugetCode(tarFeeBudgetEntity.getBudgetCode());
        feeUseBudgutParam1.setType(ConstantEnum.BudgetUesdTypeEnum.ADJUST_IMPORT.getValue());
        feeUseBudgutParam1.setAmount(adjustAmountVo.getAmountUpdate());
        feeUseBudgutParam1.setNote(adjustAmountVo.getNotes());
        feeUseBudgutParam1.setFromAddress(srcFeeBudgetEntity.getBudgetCode());
        feeUseBudgutParam1.setBusinessCode(srcFeeBudgetEntity.getBudgetCode());
        ajaxJson = this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam1);
        return ajaxJson;
    }
}

