/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.income.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.budget.income.entity.TtIncomeBudgetEntity;
import com.biz.eisp.budget.income.service.TtIncomeBudgetService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttIncomeBudgetController"})
public class TtIncomeBudgetController {
    @Autowired
    private TtIncomeBudgetService ttIncomeBudgetService;

    @GetMapping(value={"getEntity"})
    public AjaxJson<TtIncomeBudgetEntity> getEntity(@RequestParam(value="id") String id, @RequestParam(value="budgetCode") String budgetCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtIncomeBudgetEntity entity = this.ttIncomeBudgetService.getEntity(id, budgetCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @RequestMapping(value={"getMaiListPage"})
    @ResponseBody
    public DataGrid getMaiListPage(HttpServletRequest request, TtIncomeBudgetEntity entity) {
        EuPage page = new EuPage(request);
        PageInfo<TtIncomeBudgetEntity> pageInfo = this.ttIncomeBudgetService.getMaiList(entity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request, TtIncomeBudgetEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isNotEmpty((CharSequence)entity.getId()) ? this.ttIncomeBudgetService.update(entity, ajaxJson) : this.ttIncomeBudgetService.save(entity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public AjaxJson delete(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttIncomeBudgetService.delete(id, ajaxJson);
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }
}

