/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.api.controller;

import com.biz.eisp.api.feign.TmOrgFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.config.entity.TtBudgetSubjectsEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesExtendEntity;
import com.biz.eisp.budget.config.service.CategoriesExtendService;
import com.biz.eisp.budget.config.service.TtBudgetSubjectsService;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesService;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.budget.fee.service.TtFeeBudgetService;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.project.vo.ActDetailSaveVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RequestMapping(value={"/ttApiCostTypeCategoriesController"})
@RestController
public class TtApiCostTypeCategoriesController {
    @Autowired
    private TtCostTypeCategoriesService ttCostTypeCategoriesService;
    @Autowired
    private CategoriesExtendService categoriesExtendService;
    @Autowired
    private TtFeeBudgetService ttFeeBudgetService;
    @Autowired
    private TtBudgetSubjectsService ttBudgetSubjectsService;
    @Autowired
    private TmOrgFeign tmOrgFeign;

    @RequestMapping(value={"getCategoriesListPage"})
    @ResponseBody
    public DataGrid getCategoriesListPage(HttpServletRequest request, TtCostTypeCategoriesEntity ttCostTypeCategoriesEntity) {
        EuPage page = new EuPage(request);
        ttCostTypeCategoriesEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        PageInfo<TtCostTypeCategoriesEntity> pageInfo = this.ttCostTypeCategoriesService.getMaiList(ttCostTypeCategoriesEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getCategoriesListByBudgetCode"})
    @ResponseBody
    public List<TtCostTypeCategoriesEntity> getCategoriesListByBudgetCode(HttpServletRequest request, String budgetCode) {
        String orgCode = UserUtils.getUser().getOrgCode();
        TmOrgVo tmOrgVo = (TmOrgVo)this.tmOrgFeign.getOrgByIdOrCode("", orgCode).getObj();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'" + orgCode + "',");
        stringBuffer.append("'" + tmOrgVo.getOrgType() + "'");
        TtFeeBudgetEntity entity = this.ttFeeBudgetService.getEntity(null, budgetCode);
        List<Object> ttCostTypeCategoriesEntities = new ArrayList<TtCostTypeCategoriesEntity>();
        if (entity != null) {
            TtBudgetSubjectsEntity ttBudgetSubjectsEntity = this.ttBudgetSubjectsService.getEntity(null, entity.getBudgetSubjectsCode());
            Example example = new Example(TtCostTypeCategoriesEntity.class);
            Example.Criteria criteria = example.createCriteria();
            if (StringUtil.isNotEmpty((CharSequence)ttBudgetSubjectsEntity.getBudgetSubjectsCode())) {
                criteria.andEqualTo("budgetSubjectsCode", (Object)ttBudgetSubjectsEntity.getBudgetSubjectsCode());
            }
            criteria.andCondition("  EXISTS ( select id from tt_cost_type_fine_detail where  fine_code = categories_code and code in ( " + stringBuffer + " ) ) ");
            ttCostTypeCategoriesEntities = this.ttCostTypeCategoriesService.selectExample(example);
        }
        return ttCostTypeCategoriesEntities;
    }

    @RequestMapping(value={"chooseTypeListPage"})
    @ResponseBody
    public DataGrid chooseTypeListPage(HttpServletRequest request, TtCostTypeCategoriesEntity entity, String budgetCodes) {
        EuPage page = new EuPage(request);
        String[] budgetCodesArr = budgetCodes.split(",");
        PageInfo<TtCostTypeCategoriesEntity> info = this.ttCostTypeCategoriesService.chooseTypeListPage(entity, new ArrayList<String>(Arrays.asList(budgetCodesArr)), (Page)page);
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findCategoriesExtendByCode"})
    @ResponseBody
    public AjaxJson findCategoriesExtendByCode(@RequestBody String[] categoriesCodes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtCostTypeCategoriesExtendEntity> listAll = this.categoriesExtendService.findCategoriesExtendByCode(new ArrayList<String>(Arrays.asList(categoriesCodes)));
        HashMap<String, List> listMap = new HashMap<String, List>();
        listAll.stream().collect(Collectors.groupingBy(TtCostTypeCategoriesExtendEntity::getCategoriesCode, Collectors.toList())).forEach((categoriesCode, list) -> listMap.put((String)categoriesCode, (List)list));
        ArrayList vos = new ArrayList();
        List<TtCostTypeCategoriesEntity> entities = this.ttCostTypeCategoriesService.findListByCodes(new ArrayList<String>(Arrays.asList(categoriesCodes)));
        Map<String, TtCostTypeCategoriesEntity> mapCa = entities.stream().collect(Collectors.toMap(TtCostTypeCategoriesEntity::getCategoriesCode, account -> account));
        listMap.forEach((k, v) -> {
            ActDetailSaveVo vo = new ActDetailSaveVo();
            vo.setCategoriesCode(k);
            vo.setCategoriesName(((TtCostTypeCategoriesEntity)mapCa.get(k)).getCategoriesName());
            Collections.sort(v, Comparator.comparing(TtCostTypeCategoriesExtendEntity::getOrderNum));
            vo.setExtendEntities(v);
            vos.add(vo);
        });
        ajaxJson.setList(vos);
        return ajaxJson;
    }
}

