/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.fee.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.vo.FeeUseBudgutParam;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.fee.dao.TtFeeBudgetDao;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.budget.fee.service.BudgetAmountExtend;
import com.biz.eisp.budget.fee.service.BudgetAuthorityExtend;
import com.biz.eisp.budget.fee.service.TtFeeBudgetService;
import com.biz.eisp.budget.fee.vo.AdjustAmountVo;
import com.biz.eisp.budget.fee.vo.BudgetAuthorityVo;
import com.biz.eisp.budget.used.entity.TtBudgutDetailEntity;
import com.biz.eisp.budget.used.service.TtBudgutDetailService;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.OperationConfig;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.surplus.Service.TtCustPostService;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttFeeBudgetService")
@Transactional
public class TtFeeBudgetServiceImpl
extends BaseServiceImpl<TtFeeBudgetEntity>
implements TtFeeBudgetService {
    @Autowired
    private TtFeeBudgetDao ttFeeBudgetDao;
    @Autowired
    private TtBudgutDetailService ttBudgutDetailService;
    @Autowired
    private TtCustPostService ttCustPostService;
    @Autowired(required=false)
    private BudgetAuthorityExtend budgetAuthorityExtend;
    @Autowired(required=false)
    private BudgetAmountExtend budgetAmountExtend;

    @Override
    public PageInfo<TtFeeBudgetEntity> getMaiListSelect(TtFeeBudgetEntity ttFeeBudgetEntity, Page page) {
        BudgetAuthorityVo budgetAuthorityVo = null;
        if (this.budgetAuthorityExtend != null) {
            budgetAuthorityVo = this.budgetAuthorityExtend.createBudgetAuthority();
        }
        if (budgetAuthorityVo != null) {
            if (budgetAuthorityVo.getBudgetSubjectsCode() != null) {
                budgetAuthorityVo.getBudgetSubjectsCode().add("_");
            }
            if (budgetAuthorityVo.getVkorgCode() != null) {
                budgetAuthorityVo.getVkorgCode().add("_");
            }
            if (budgetAuthorityVo.getBudgetDepartCode() != null) {
                budgetAuthorityVo.getBudgetDepartCode().add("_");
            }
            if (budgetAuthorityVo.getProductCode() != null) {
                budgetAuthorityVo.getProductCode().add("_");
            }
            if (budgetAuthorityVo.getCustCode() != null) {
                budgetAuthorityVo.getCustCode().add("_");
            }
            if (budgetAuthorityVo.getTerminalCode() != null) {
                budgetAuthorityVo.getTerminalCode().add("_");
            }
            if (budgetAuthorityVo.getPositionCode() != null) {
                budgetAuthorityVo.getPositionCode().add("_");
            }
        }
        BudgetAuthorityVo budgetAuthorityVoTemp = budgetAuthorityVo;
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.ttFeeBudgetDao.getMaiListSelect(ttFeeBudgetEntity, budgetAuthorityVoTemp), (Page)page);
        if (this.budgetAmountExtend != null) {
            this.budgetAmountExtend.budgetAmount(pageInfo.getList());
        }
        return pageInfo;
    }

    @Override
    public PageInfo<TtFeeBudgetEntity> getMaiList(TtFeeBudgetEntity ttFeeBudgetEntity, Page page) {
        String flagTemp;
        ArrayList custCodes;
        ArrayList orgCodes;
        PageInfo pageInfo;
        List<Object> orgCodesAll = new ArrayList();
        List<Object> custCodesAll = new ArrayList();
        String funId = ThreadLocalUtil.getVal();
        UserRedis userRedis = UserUtils.getUser();
        String flag = null;
        if (OperationConfig.checkOperation((String)funId, (UserRedis)userRedis)) {
            List list = OperationConfig.getOperationAuthobj((String)funId);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                List operationAuthobjs = OperationConfig.getOperationAuthobj((String)funId);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)operationAuthobjs)) {
                    HashMap<String, OperationAuthobj> mapTemp = new HashMap<String, OperationAuthobj>();
                    for (OperationAuthobj item2 : operationAuthobjs) {
                        mapTemp.put(item2.getAuthobj(), item2);
                    }
                    if (mapTemp.containsKey("org")) {
                        orgCodesAll = OperationConfig.getOperationAuthobjCode((List)list, (String)"org", (UserRedis)userRedis);
                        orgCodesAll = orgCodesAll.stream().distinct().collect(Collectors.toList());
                    }
                    if (mapTemp.containsKey("position")) {
                        custCodesAll = OperationConfig.getOperationAuthobjCode((List)list, (String)"customer", (UserRedis)userRedis);
                        custCodesAll = custCodesAll.stream().distinct().collect(Collectors.toList());
                    }
                } else {
                    flag = "1=2";
                }
            } else {
                flag = "1=2";
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(pageInfo = PageAutoHelperUtil.generatePage(() -> this.lambda$getMaiList$2(ttFeeBudgetEntity, orgCodes = orgCodesAll, custCodes = custCodesAll, flagTemp = flag), (Page)page)).getList())) {
            pageInfo.getList().forEach(item -> {});
        }
        return pageInfo;
    }

    private BigDecimal getMoney(String typeCode, String budgetCode) {
        TtBudgutDetailEntity ttBudgutDetailEntity = new TtBudgutDetailEntity();
        ttBudgutDetailEntity.setBudgetCode(budgetCode);
        ttBudgutDetailEntity.setTypeCode(typeCode);
        List<TtBudgutDetailEntity> ttBudgutDetailEntities = this.ttBudgutDetailService.getMaiList(ttBudgutDetailEntity);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (TtBudgutDetailEntity entity : ttBudgutDetailEntities) {
            bigDecimal = bigDecimal.add(entity.getFeeAmount());
        }
        return bigDecimal;
    }

    @Override
    public TtFeeBudgetEntity getEntity(String id, String budgetCode) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)budgetCode)) {
            return null;
        }
        Example example = new Example(TtFeeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)budgetCode)) {
            criteria.andEqualTo("budgetCode", (Object)budgetCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttFeeBudgetDao.selectByExample(example)))) {
            return (TtFeeBudgetEntity)list.get(0);
        }
        return null;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtFeeBudgetServiceImpl.class)
    public AjaxJson update(TtFeeBudgetEntity entity, AjaxJson ajaxJson) {
        entity.setInitAmount(null);
        this.ttFeeBudgetDao.updateByPrimaryKeySelective(entity);
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson updateAmount(TtFeeBudgetEntity ttFeeBudgetEntity, AjaxJson ajaxJson) {
        if (ttFeeBudgetEntity.getAmountUpdate() == null) {
            ajaxJson.setErrMsg("\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
        feeUseBudgutParam.setBugetCode(ttFeeBudgetEntity.getBudgetCode());
        feeUseBudgutParam.setType(ttFeeBudgetEntity.getChangeType());
        feeUseBudgutParam.setAmount(ttFeeBudgetEntity.getAmountUpdate());
        feeUseBudgutParam.setNote(ttFeeBudgetEntity.getNotes());
        ajaxJson = this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam);
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(ttFeeBudgetEntity.getBudgetCode(), ttFeeBudgetEntity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtFeeBudgetServiceImpl.class)
    public AjaxJson save(TtFeeBudgetEntity entity, AjaxJson ajaxJson) {
        if (entity.getInitAmount() == null) {
            ajaxJson.setErrMsg("\u521d\u59cb\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        entity.setBudgetCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.fee_budget.name()));
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.ttFeeBudgetDao.insertSelective(entity);
        FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
        feeUseBudgutParam.setBugetCode(entity.getBudgetCode());
        feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.INIT.getValue());
        feeUseBudgutParam.setAmount(entity.getInitAmount());
        feeUseBudgutParam.setNote("\u65b0\u589e");
        this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam);
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson delete(String id, AjaxJson ajaxJson) {
        TtFeeBudgetEntity ttFeeBudgetEntity = (TtFeeBudgetEntity)this.ttFeeBudgetDao.selectByPrimaryKey(id);
        Example example = new Example(TtBudgutDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("budgetCode", (Object)ttFeeBudgetEntity.getBudgetCode());
        ArrayList<String> list = new ArrayList<String>();
        list.add(ConstantEnum.BudgetUesdTypeEnum.ADJUST_OUT.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.ADJUST_IMPORT.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.ADDITIONAL.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.CUTOUT.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.USE.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.BACK.getValue());
        criteria.andIn("typeCode", list);
        List ttBudgutDetailEntities = this.ttBudgutDetailService.selectExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)ttBudgutDetailEntities)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u9884\u7b97\u7f16\u53f7\u4e3a" + ttFeeBudgetEntity.getBudgetCode() + "\u7684\u8d39\u7528\u9884\u7b97\u5df2\u7ecf\u4ea7\u751f\u660e\u7ec6\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            return ajaxJson;
        }
        TtFeeBudgetEntity entity = new TtFeeBudgetEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
        entity.setId(id);
        this.ttFeeBudgetDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }

    @Override
    public List<TtFeeBudgetEntity> getEntityByCodes(List<String> budgetCodes) {
        Example example = new Example(TtFeeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("budgetCode", budgetCodes);
        return this.ttFeeBudgetDao.selectByExample(example);
    }

    @Override
    public AjaxJson adjustAmount(AdjustAmountVo adjustAmountVo, AjaxJson ajaxJson) {
        if (StringUtil.isEmpty((String)adjustAmountVo.getSrcId()) || StringUtil.isEmpty((String)adjustAmountVo.getTarId())) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        TtFeeBudgetEntity srcFeeBudgetEntity = this.getEntity(adjustAmountVo.getSrcId(), null);
        TtFeeBudgetEntity tarFeeBudgetEntity = this.getEntity(adjustAmountVo.getTarId(), null);
        FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
        feeUseBudgutParam.setBugetCode(srcFeeBudgetEntity.getBudgetCode());
        feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.ADJUST_OUT.getValue());
        feeUseBudgutParam.setAmount(adjustAmountVo.getAmountUpdate());
        feeUseBudgutParam.setNote(adjustAmountVo.getNotes());
        feeUseBudgutParam.setBusinessCode(tarFeeBudgetEntity.getBudgetCode());
        ajaxJson = this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        FeeUseBudgutParam feeUseBudgutParam1 = new FeeUseBudgutParam();
        feeUseBudgutParam1.setBugetCode(tarFeeBudgetEntity.getBudgetCode());
        feeUseBudgutParam1.setType(ConstantEnum.BudgetUesdTypeEnum.ADJUST_IMPORT.getValue());
        feeUseBudgutParam1.setAmount(adjustAmountVo.getAmountUpdate());
        feeUseBudgutParam1.setNote(adjustAmountVo.getNotes());
        feeUseBudgutParam1.setFromAddress(srcFeeBudgetEntity.getBudgetCode());
        feeUseBudgutParam1.setBusinessCode(srcFeeBudgetEntity.getBudgetCode());
        ajaxJson = this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam1);
        return ajaxJson;
    }

    private /* synthetic */ List lambda$getMaiList$2(TtFeeBudgetEntity ttFeeBudgetEntity, List list, List list2, String string) {
        return this.ttFeeBudgetDao.getMaiList(ttFeeBudgetEntity, list, list2, string);
    }
}

