/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.fee.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.budget.fee.service.TtFeeBudgetService;
import com.biz.eisp.budget.fee.vo.AdjustAmountVo;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttFeeBudgetController"})
public class TtFeeBudgetController {
    @Autowired
    private TtFeeBudgetService ttFeeBudgetService;

    @GetMapping(value={"getEntity"})
    public AjaxJson<TtFeeBudgetEntity> getEntity(@RequestParam(value="id", required=false) String id, @RequestParam(value="budgetCode", required=false) String budgetCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtFeeBudgetEntity entity = this.ttFeeBudgetService.getEntity(id, budgetCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @RequestMapping(value={"getSelectPage"})
    @ResponseBody
    public DataGrid getSelectPage(HttpServletRequest request, TtFeeBudgetEntity ttFeeBudgetEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtFeeBudgetEntity> pageInfo = this.ttFeeBudgetService.getMaiList(ttFeeBudgetEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getMaiListPage"})
    @ResponseBody
    public DataGrid getMaiListPage(HttpServletRequest request, TtFeeBudgetEntity ttFeeBudgetEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtFeeBudgetEntity> pageInfo = this.ttFeeBudgetService.getMaiList(ttFeeBudgetEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getMaiListSelect"})
    @ResponseBody
    public DataGrid getMaiListSelect(HttpServletRequest request, TtFeeBudgetEntity ttFeeBudgetEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtFeeBudgetEntity> pageInfo = this.ttFeeBudgetService.getMaiListSelect(ttFeeBudgetEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"updateAmount"})
    @ResponseBody
    public AjaxJson updateAmount(HttpServletRequest request, TtFeeBudgetEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = this.ttFeeBudgetService.updateAmount(entity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"adjustAmount"})
    @ResponseBody
    public AjaxJson adjustAmount(@RequestBody AdjustAmountVo adjustAmountVo) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = this.ttFeeBudgetService.adjustAmount(adjustAmountVo, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request, TtFeeBudgetEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isNotEmpty((CharSequence)entity.getId()) ? this.ttFeeBudgetService.update(entity, ajaxJson) : this.ttFeeBudgetService.save(entity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public AjaxJson delete(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttFeeBudgetService.delete(id, ajaxJson);
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761").append("," + ajaxJson.getMsg());
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"findFeeBudgetByCode"})
    @ResponseBody
    public AjaxJson<TtFeeBudgetEntity> findFeeBudgetByCode(TtFeeBudgetEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        if (entity == null) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        TtFeeBudgetEntity feeBudgetEntity = this.ttFeeBudgetService.getEntity(entity.getId(), entity.getBudgetCode());
        ajaxJson.setObj((Object)feeBudgetEntity);
        return ajaxJson;
    }

    @RequestMapping(value={"getSubjectsGroupData"})
    @ResponseBody
    public AjaxJson getSubjectsGroupData(String dictCode) {
        AjaxJson ajaxJson = new AjaxJson();
        ArrayList<String> list = new ArrayList<String>();
        KnlDictDataEntity knlDictDataEntity = DictUtil.getDicData((String)"budget_group", (String)dictCode);
        List dictListByParentId = null;
        if (knlDictDataEntity != null) {
            dictListByParentId = DictUtil.getDictListByParentId((String)knlDictDataEntity.getId());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(dictListByParentId)) {
            for (KnlDictDataEntity entity : dictListByParentId) {
                if (!StringUtil.isNotEmpty((CharSequence)entity.getDictCode())) continue;
                list.add(entity.getDictCode());
            }
        }
        ajaxJson.setObjList(list);
        return ajaxJson;
    }

    @GetMapping(value={"getEntityByCodes"})
    public AjaxJson<TtFeeBudgetEntity> getEntityByCodes(@RequestParam(value="codes") List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtFeeBudgetEntity> entities = this.ttFeeBudgetService.getEntityByCodes(codes);
        ajaxJson.setList(entities);
        return ajaxJson;
    }
}

