/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.income.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.income.dao.TtIncomeBudgetDao;
import com.biz.eisp.budget.income.entity.TtIncomeBudgetEntity;
import com.biz.eisp.budget.income.service.TtIncomeBudgetService;
import com.biz.eisp.budget.used.service.TtBudgutDetailService;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.OperationConfig;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.surplus.Service.TtCustPostService;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttIncomeBudgetService")
@Transactional
public class TtIncomeBudgetServiceImpl
extends BaseServiceImpl<TtIncomeBudgetEntity>
implements TtIncomeBudgetService {
    @Autowired
    private TtIncomeBudgetDao ttIncomeBudgetDao;
    @Autowired
    private TtBudgutDetailService ttBudgutDetailService;
    @Autowired
    private TtCustPostService ttCustPostService;

    @Override
    public PageInfo<TtIncomeBudgetEntity> getMaiList(TtIncomeBudgetEntity entity, Page page) {
        List<Object> orgCodesAll = new ArrayList();
        List<Object> custCodesAll = new ArrayList();
        String funId = ThreadLocalUtil.getVal();
        UserRedis userRedis = UserUtils.getUser();
        String flag = null;
        if (OperationConfig.checkOperation((String)funId, (UserRedis)userRedis)) {
            List list = OperationConfig.getOperationAuthobj((String)funId);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                List operationAuthobjs = OperationConfig.getOperationAuthobj((String)funId);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)operationAuthobjs)) {
                    HashMap<String, OperationAuthobj> mapTemp = new HashMap<String, OperationAuthobj>();
                    for (OperationAuthobj item : operationAuthobjs) {
                        mapTemp.put(item.getAuthobj(), item);
                    }
                    if (mapTemp.containsKey("org")) {
                        orgCodesAll = OperationConfig.getOperationAuthobjCode((List)list, (String)"org", (UserRedis)userRedis);
                        orgCodesAll = orgCodesAll.stream().distinct().collect(Collectors.toList());
                    }
                    if (mapTemp.containsKey("position")) {
                        custCodesAll = OperationConfig.getOperationAuthobjCode((List)list, (String)"customer", (UserRedis)userRedis);
                        custCodesAll = custCodesAll.stream().distinct().collect(Collectors.toList());
                    }
                } else {
                    flag = "1=2";
                }
            } else {
                flag = "1=2";
            }
        }
        ArrayList orgCodes = orgCodesAll;
        ArrayList custCodes = custCodesAll;
        String flagTemp = flag;
        return PageAutoHelperUtil.generatePage(() -> this.ttIncomeBudgetDao.getMaiList(entity, orgCodes, custCodes, flagTemp), (Page)page);
    }

    @Override
    public TtIncomeBudgetEntity getEntity(String id, String budgetCode) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)budgetCode)) {
            return null;
        }
        Example example = new Example(TtIncomeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)budgetCode)) {
            criteria.andEqualTo("budgetCode", (Object)budgetCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttIncomeBudgetDao.selectByExample(example)))) {
            return (TtIncomeBudgetEntity)list.get(0);
        }
        return null;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtIncomeBudgetServiceImpl.class)
    public AjaxJson update(TtIncomeBudgetEntity entity, AjaxJson ajaxJson) {
        this.ttIncomeBudgetDao.updateByPrimaryKeySelective(entity);
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtIncomeBudgetServiceImpl.class)
    public AjaxJson save(TtIncomeBudgetEntity entity, AjaxJson ajaxJson) {
        if (entity.getInitAmount() == null) {
            ajaxJson.setErrMsg("\u521d\u59cb\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        entity.setBudgetCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.income_budget.name()));
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.ttIncomeBudgetDao.insertSelective(entity);
        this.ttBudgutDetailService.incomeFeeBudgutDetail(entity.getBudgetCode(), ConstantEnum.BudgetUesdTypeEnum.INIT.getValue(), entity.getInitAmount(), "\u65b0\u589e");
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson delete(String id, AjaxJson ajaxJson) {
        TtIncomeBudgetEntity entity = new TtIncomeBudgetEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
        entity.setId(id);
        this.ttIncomeBudgetDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }
}

