/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.special.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.budget.fee.entity.TtSpecialAreaEntity;
import com.biz.eisp.budget.special.service.TtSpecialAreaService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttSpecialAreaController"})
public class TtSpecialAreaController {
    @Autowired
    private TtSpecialAreaService ttSpecialAreaService;

    @GetMapping(value={"getEntity"})
    @ResponseBody
    public AjaxJson<TtSpecialAreaEntity> getEntity(@RequestParam(value="id", required=false) String id, @RequestParam(value="code", required=false) String code) {
        AjaxJson ajaxJson = new AjaxJson();
        TtSpecialAreaEntity entity = this.ttSpecialAreaService.getEntity(id, code);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @RequestMapping(value={"getMainListPage"})
    @ResponseBody
    public DataGrid getMainListPage(HttpServletRequest request, TtSpecialAreaEntity ttFeeBudgetExtendEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtSpecialAreaEntity> pageInfo = this.ttSpecialAreaService.getMainList(ttFeeBudgetExtendEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @ApiOperation(value="\u6839\u636e\u7279\u6b8a\u533a\u57df\u7c7b\u578b\u67e5\u8be2\u7f16\u7801\u4fe1\u606f", notes="\u6839\u636e\u7279\u6b8a\u533a\u57df\u7c7b\u578b\u67e5\u8be2\u7f16\u7801\u4fe1\u606f  \u7ec4\u7ec7\u7c7b\u578b\u548c\u7f16\u7801\u53d6\u5e76\u96c6\uff0c{\"type\":\"\u7c7b\u578b(\u5fc5\u4f20)\",\"orgCodes\":\"\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\",\"orgTypes\":\"\u7ec4\u7ec7\u7c7b\u578b\u96c6\u5408\"},\u8fd4\u56de\u503c\u5728ObjList", httpMethod="POST")
    @PostMapping(value={"getCodeList"})
    @ResponseBody
    public AjaxJson<String> getCodeList(@RequestParam(value="type") String type, @RequestParam(value="orgCodes", required=false) List<String> orgCodes, @RequestParam(value="orgTypes", required=false) List<String> orgTypes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<String> codes = this.ttSpecialAreaService.getCodeList(type, orgCodes, orgTypes);
        ajaxJson.setObjList(codes);
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request, TtSpecialAreaEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isEmpty((String)entity.getId()) ? this.ttSpecialAreaService.save(entity, ajaxJson) : this.ttSpecialAreaService.update(entity, ajaxJson);
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"delete"})
    public AjaxJson delete(@RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = this.ttSpecialAreaService.delete(ids, ajaxJson);
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"stopOrStart"})
    public AjaxJson stopOrStart(TtSpecialAreaEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = this.ttSpecialAreaService.stopOrStart(entity, ajaxJson);
        return ajaxJson;
    }
}

