/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.config.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.entity.BaseEntity;
import com.biz.eisp.base.utils.DataDriverUtilService;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.config.dao.TtCostTypeFineDao;
import com.biz.eisp.budget.config.dao.TtCostTypeFineDetailDao;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineDetailEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.budget.config.service.TypeFinegetActFinesListByCatgeExtend;
import com.biz.eisp.budget.config.vo.ActFineVo;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.biz.eisp.util.ReflectionUtils;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttCostTypeFineService")
@Transactional
public class TtCostTypeFineServiceImpl
extends BaseServiceImpl<TtCostTypeFineEntity>
implements TtCostTypeFineService {
    @Autowired
    private TtCostTypeFineDao ttCostTypeFineDao;
    @Autowired
    private TtCostTypeFineDetailDao ttCostTypeFineDetailDao;
    @Autowired
    private DataDriverUtilService dataDriverUtilService;
    @Autowired(required=false)
    private TypeFinegetActFinesListByCatgeExtend typeFinegetActFinesListByCatgeExtend;

    @Override
    public PageInfo<TtCostTypeFineEntity> getMaiList(TtCostTypeFineEntity ttCostTypeFineEntity, Page page) {
        Example example = new Example(TtCostTypeFineEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getFineCode())) {
            criteria.andLike("fineCode", "%" + ttCostTypeFineEntity.getFineCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getTableType())) {
            criteria.andLike("tableType", "%" + ttCostTypeFineEntity.getTableType() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getFineName())) {
            criteria.andLike("fineName", "%" + ttCostTypeFineEntity.getFineName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getCategoriesCode())) {
            criteria.andLike("categoriesCode", "%" + ttCostTypeFineEntity.getCategoriesCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getCategoriesName())) {
            criteria.andLike("categoriesName", "%" + ttCostTypeFineEntity.getCategoriesName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getBudgetSubjectsCode())) {
            criteria.andLike("budgetSubjectsCode", "%" + ttCostTypeFineEntity.getBudgetSubjectsCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getBudgetSubjectsName())) {
            criteria.andLike("budgetSubjectsName", "%" + ttCostTypeFineEntity.getBudgetSubjectsName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getActMethodCode())) {
            criteria.andLike("actMethodCode", "%" + ttCostTypeFineEntity.getActMethodCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getActMethodName())) {
            criteria.andLike("actMethodName", "%" + ttCostTypeFineEntity.getActMethodName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getIsAudit())) {
            criteria.andEqualTo("isAudit", (Object)ttCostTypeFineEntity.getIsAudit());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getIsPushSfa())) {
            criteria.andEqualTo("isPushSfa", (Object)ttCostTypeFineEntity.getIsPushSfa());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getIsMultipleAudit())) {
            criteria.andEqualTo("isMultipleAudit", (Object)ttCostTypeFineEntity.getIsMultipleAudit());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getIsControlTer())) {
            criteria.andEqualTo("isControlTer", (Object)ttCostTypeFineEntity.getIsControlTer());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getIsControlPro())) {
            criteria.andEqualTo("isControlPro", (Object)ttCostTypeFineEntity.getIsControlPro());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getIsEnableAi())) {
            criteria.andEqualTo("isEnableAi", (Object)ttCostTypeFineEntity.getIsEnableAi());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getEnableStatus())) {
            criteria.andEqualTo("enableStatus", (Object)ttCostTypeFineEntity.getEnableStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getCreateName())) {
            criteria.andLike("createName", "%" + ttCostTypeFineEntity.getCreateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getUpdateName())) {
            criteria.andLike("updateName", "%" + ttCostTypeFineEntity.getUpdateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getExtChar1())) {
            criteria.andLike("extChar1", "%" + ttCostTypeFineEntity.getExtChar1() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getExtChar2())) {
            criteria.andLike("extChar2", "%" + ttCostTypeFineEntity.getExtChar2() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getExtChar3())) {
            criteria.andLike("extChar3", "%" + ttCostTypeFineEntity.getExtChar3() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getExtChar4())) {
            criteria.andLike("extChar4", "%" + ttCostTypeFineEntity.getExtChar4() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getExtChar5())) {
            criteria.andLike("extChar5", "%" + ttCostTypeFineEntity.getExtChar5() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getCategoriesStatus())) {
            criteria.andEqualTo("categoriesStatus", (Object)ttCostTypeFineEntity.getCategoriesStatus());
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttCostTypeFineDao.selectByExample(example), (Page)page);
    }

    @Override
    public PageInfo<TtCostTypeFineEntity> getSelectFinePage(TtCostTypeFineEntity ttCostTypeFineEntity, String dataType, Page page) {
        Example example = new Example(TtCostTypeFineEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getFineCode())) {
            criteria.andLike("fineCode", "%" + ttCostTypeFineEntity.getFineCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getFineName())) {
            criteria.andLike("fineName", "%" + ttCostTypeFineEntity.getFineName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getCreateName())) {
            criteria.andLike("createName", "%" + ttCostTypeFineEntity.getCreateName() + "%");
        }
        if (StringUtil.equals((String)ConstantEnum.YesNoEnum.ZERO.getValue(), (String)dataType)) {
            if (this.dataDriverUtilService.isMysql()) {
                criteria.andCondition(" IFNULL(categories_code,'')='' ");
            } else if (this.dataDriverUtilService.isOracle()) {
                criteria.andCondition(" nvl(categories_code,'')='' ");
            } else {
                criteria.andIsNull("categoriesCode");
            }
        } else {
            if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getCategoriesCode())) {
                criteria.andLike("categoriesCode", "%" + ttCostTypeFineEntity.getCategoriesCode() + "%");
            }
            if (StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getCategoriesName())) {
                criteria.andLike("categoriesName", "%" + ttCostTypeFineEntity.getCategoriesName() + "%");
            }
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttCostTypeFineDao.selectByExample(example), (Page)page);
    }

    @Override
    public TtCostTypeFineEntity getFineEntity(String id, String fineCode) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)fineCode)) {
            return null;
        }
        Example example = new Example(TtCostTypeFineEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)fineCode)) {
            criteria.andEqualTo("fineCode", (Object)fineCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttCostTypeFineDao.selectByExample(example)))) {
            return (TtCostTypeFineEntity)list.get(0);
        }
        return null;
    }

    @Override
    public AjaxJson deleteFineByCategories(String categoriesCode, AjaxJson ajaxJson) {
        Example example = new Example(TtCostTypeFineEntity.class);
        Example.Criteria criteria = example.createCriteria();
        TtCostTypeFineEntity ttCostTypeFineEntity = new TtCostTypeFineEntity();
        ttCostTypeFineEntity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
        criteria.andEqualTo("categoriesCode", (Object)categoriesCode);
        this.ttCostTypeFineDao.updateByExampleSelective(ttCostTypeFineEntity, example);
        return ajaxJson;
    }

    @Override
    public AjaxJson stopOrStartFine(String id, AjaxJson ajaxJson, String type) {
        TtCostTypeFineEntity ttCostTypeFineEntity = new TtCostTypeFineEntity();
        ttCostTypeFineEntity.setId(id);
        ttCostTypeFineEntity.setEnableStatus(type);
        this.ttCostTypeFineDao.updateByPrimaryKeySelective(ttCostTypeFineEntity);
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtCostTypeFineServiceImpl.class)
    public AjaxJson save(TtCostTypeFineEntity entity, AjaxJson ajaxJson) {
        entity.setFineCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.act_fine.name()));
        this.ttCostTypeFineDao.insertSelective(entity);
        TtCostTypeFineEntity newEntity = (TtCostTypeFineEntity)this.ttCostTypeFineDao.selectByPrimaryKey(entity.getId());
        this.saveOrUpdateFineExpand(newEntity, entity);
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtCostTypeFineServiceImpl.class)
    public AjaxJson update(TtCostTypeFineEntity entity, AjaxJson ajaxJson) {
        this.ttCostTypeFineDao.updateByPrimaryKeySelective(entity);
        TtCostTypeFineEntity newEntity = (TtCostTypeFineEntity)this.ttCostTypeFineDao.selectByPrimaryKey(entity.getId());
        this.saveOrUpdateFineExpand(newEntity, entity);
        return ajaxJson;
    }

    public void saveOrUpdateFineExpand(TtCostTypeFineEntity newEntity, TtCostTypeFineEntity entity) {
        String fineCode = newEntity.getFineCode();
        Map mapType = DictUtil.getDictMap((String)"act_expand_type");
        Example exampleAll = new Example(TtCostTypeFineDetailEntity.class);
        Example.Criteria criteriaAll = exampleAll.createCriteria();
        criteriaAll.andEqualTo("fineCode", (Object)fineCode);
        List oldDetails = this.ttCostTypeFineDetailDao.selectByExample(exampleAll);
        HashMap detailMap = new HashMap();
        oldDetails.stream().collect(Collectors.groupingBy(TtCostTypeFineDetailEntity::getType, Collectors.toList())).forEach((type, list) -> detailMap.put(type, list));
        ArrayList<TtCostTypeFineDetailEntity> deleteItems = new ArrayList<TtCostTypeFineDetailEntity>();
        ArrayList noDoList = new ArrayList();
        ArrayList<TtCostTypeFineDetailEntity> addList = new ArrayList<TtCostTypeFineDetailEntity>();
        mapType.forEach((keyMap, valTemp) -> {
            String formVals;
            String key = keyMap.toString();
            KnlDictDataEntity val = (KnlDictDataEntity)valTemp;
            Object value = ReflectionUtils.getFieldValue((Object)entity, (String)val.getDictValue());
            String string2 = formVals = StringUtil.isNotEmpty((Object)value) ? value.toString() : "";
            if (StringUtil.isEmpty((String)formVals)) {
                if (StringUtil.isNotEmpty(detailMap.get(key))) {
                    deleteItems.addAll((Collection)detailMap.get(key));
                }
            } else {
                String[] formValArry = formVals.split(",");
                Map<String, String> mapTemp = this.changeData(formValArry);
                List oldListTemp = (List)detailMap.get(key);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)oldListTemp)) {
                    oldListTemp.forEach(item -> {
                        if (mapTemp.containsKey(item.getType())) {
                            noDoList.add(item);
                            mapTemp.remove(item.getType());
                        } else {
                            deleteItems.add((TtCostTypeFineDetailEntity)item);
                        }
                    });
                }
                if (!mapTemp.isEmpty()) {
                    List<TtCostTypeFineDetailEntity> tempAdd = this.createEntity(mapTemp, fineCode, val);
                    addList.addAll(tempAdd);
                }
            }
        });
        this.saveOrUpdateData(deleteItems, addList);
    }

    private void saveOrUpdateData(List<TtCostTypeFineDetailEntity> deleteItems, List<TtCostTypeFineDetailEntity> addList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteItems)) {
            Example exampleDelete = new Example(TtCostTypeFineDetailEntity.class);
            Example.Criteria criteria = exampleDelete.createCriteria();
            List ids = deleteItems.stream().map(BaseEntity::getId).collect(Collectors.toList());
            criteria.andIn("id", ids);
            this.ttCostTypeFineDetailDao.deleteByExample(exampleDelete);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            addList.forEach(itme -> this.ttCostTypeFineDetailDao.insertSelective(itme));
        }
    }

    private List<TtCostTypeFineDetailEntity> createEntity(Map<String, String> mapTemp, String fineCode, KnlDictDataEntity typeDic) {
        ArrayList<TtCostTypeFineDetailEntity> adds = new ArrayList<TtCostTypeFineDetailEntity>();
        Map mapType = DictUtil.getDictMap((String)typeDic.getDictCode());
        HashMap mapTypeNew = new HashMap();
        mapType.forEach((k, v) -> mapTypeNew.put(k.toString(), v.toString()));
        mapTemp.forEach((k, v) -> {
            KnlDictDataEntity dictDataEntity = (KnlDictDataEntity)mapType.get(k);
            TtCostTypeFineDetailEntity entity = new TtCostTypeFineDetailEntity();
            entity.setFineCode(fineCode);
            entity.setType(typeDic.getDictCode());
            entity.setTypeName(typeDic.getDictValue());
            entity.setCode(k);
            entity.setName(dictDataEntity.getDictValue());
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            adds.add(entity);
        });
        return adds;
    }

    private Map<String, String> changeData(String[] formValArry) {
        HashMap<String, String> formValMap = new HashMap<String, String>();
        for (String formVa : formValArry) {
            if (StringUtil.isEmpty((Object)formValArry)) continue;
            formValMap.put(formVa, formVa);
        }
        return formValMap;
    }

    @Override
    public List<TtCostTypeFineEntity> getFinesByCategoriesCode(String categoriesCode) {
        if (StringUtil.isEmpty((String)categoriesCode)) {
            return new ArrayList<TtCostTypeFineEntity>();
        }
        Example example = new Example(TtCostTypeFineEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("categoriesCode", (Object)categoriesCode);
        return this.ttCostTypeFineDao.selectByExample(example);
    }

    @Override
    public List<TtCostTypeFineEntity> getFinesByCategoriesCode(Example example) {
        return this.ttCostTypeFineDao.selectByExample(example);
    }

    @Override
    public void relevanceFine(List<TtCostTypeFineEntity> addList, List<TtCostTypeFineEntity> updateList, List<TtCostTypeFineEntity> delist, TtCostTypeCategoriesEntity costTypeCategoriesEntity) {
        List ids;
        Example.Criteria criteria;
        TtCostTypeFineEntity update;
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            update = new TtCostTypeFineEntity();
            this.relevanceFinePram(update, costTypeCategoriesEntity);
            Example exampleAdd = new Example(TtCostTypeFineEntity.class);
            criteria = exampleAdd.createCriteria();
            ids = addList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            criteria.andIn("id", ids);
            this.ttCostTypeFineDao.updateByExampleSelective(update, exampleAdd);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            update = new TtCostTypeFineEntity();
            this.relevanceFinePram(update, costTypeCategoriesEntity);
            Example exampleUpdate = new Example(TtCostTypeFineEntity.class);
            criteria = exampleUpdate.createCriteria();
            ids = updateList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            criteria.andIn("id", ids);
            this.ttCostTypeFineDao.updateByExampleSelective(update, exampleUpdate);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(delist)) {
            update = new TtCostTypeFineEntity();
            this.relevanceFinePram(update, null);
            Example exampleDel = new Example(TtCostTypeFineEntity.class);
            criteria = exampleDel.createCriteria();
            ids = delist.stream().map(BaseEntity::getId).collect(Collectors.toList());
            criteria.andIn("id", ids);
            this.ttCostTypeFineDao.updateByExampleSelective(update, exampleDel);
        }
    }

    private void relevanceFinePram(TtCostTypeFineEntity ttCostTypeFineEntity, TtCostTypeCategoriesEntity costTypeCategoriesEntity) {
        if (costTypeCategoriesEntity != null) {
            ttCostTypeFineEntity.setCategoriesCode(costTypeCategoriesEntity.getCategoriesCode());
            ttCostTypeFineEntity.setCategoriesName(costTypeCategoriesEntity.getCategoriesName());
            ttCostTypeFineEntity.setBudgetSubjectsCode(costTypeCategoriesEntity.getBudgetSubjectsCode());
            ttCostTypeFineEntity.setBudgetSubjectsName(costTypeCategoriesEntity.getBudgetSubjectsName());
            ttCostTypeFineEntity.setCategoriesStatus(costTypeCategoriesEntity.getEnableStatus());
        } else {
            ttCostTypeFineEntity.setCategoriesCode("");
            ttCostTypeFineEntity.setCategoriesName("");
            ttCostTypeFineEntity.setBudgetSubjectsCode("");
            ttCostTypeFineEntity.setBudgetSubjectsName("");
            ttCostTypeFineEntity.setCategoriesStatus("");
        }
    }

    @Override
    public Map<String, List<TtCostTypeFineDetailEntity>> findCostTypeCons(String fineCode, List<String> cons) {
        Example example = new Example(TtCostTypeFineDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("fineCode", (Object)fineCode);
        criteria.andIn("type", cons);
        List listEntity = this.ttCostTypeFineDetailDao.selectByExample(example);
        HashMap<String, List<TtCostTypeFineDetailEntity>> typeListMap = new HashMap<String, List<TtCostTypeFineDetailEntity>>();
        listEntity.stream().collect(Collectors.groupingBy(TtCostTypeFineDetailEntity::getType, Collectors.toList())).forEach((type, list) -> typeListMap.put((String)type, (List<TtCostTypeFineDetailEntity>)list));
        return typeListMap;
    }

    @Override
    public void updateBudgetSubjectsName(String budgetSubjectsName, String budgetSubjectsCode) {
        this.ttCostTypeFineDao.updateBudgetSubjectsName(budgetSubjectsName, budgetSubjectsCode);
    }

    @Override
    public Boolean checkProductByFineCode(List<String> codes) {
        boolean flag = false;
        block0: for (String code : codes) {
            if (flag) break;
            ArrayList<String> types = new ArrayList<String>();
            String act_name = ConstantEnum.FIELD_NAME.act_release_need.name();
            types.add(act_name);
            Map<String, List<TtCostTypeFineDetailEntity>> map = this.findCostTypeCons(code, types);
            if (map == null || !map.containsKey(act_name) || !CollectionUtil.listNotEmptyNotSizeZero(map.get(act_name))) continue;
            for (TtCostTypeFineDetailEntity item : map.get(act_name)) {
                if (!StringUtils.equals((CharSequence)item.getCode(), (CharSequence)ConstantEnum.FIELD_NAME.product.name())) continue;
                flag = true;
                continue block0;
            }
        }
        return flag;
    }

    @Override
    public PageInfo<TtCostTypeFineEntity> getActFinesList(TtCostTypeFineEntity ttCostTypeFineEntity, List<String> codes, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttCostTypeFineDao.getActFinesList(ttCostTypeFineEntity, codes), (Page)page);
    }

    @Override
    public PageInfo<TtCostTypeFineEntity> getActFinesListByCatge(TtCostTypeFineEntity ttCostTypeFineEntity, Page page) {
        UserRedis userRedis = UserUtils.getUser();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.typeFinegetActFinesListByCatgeExtend != null) {
            String sql = this.typeFinegetActFinesListByCatgeExtend.getActFinesListByCatge(ttCostTypeFineEntity, userRedis);
            stringBuffer.append(sql);
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttCostTypeFineDao.getActFinesListByCatge(ttCostTypeFineEntity, stringBuffer.toString()), (Page)page);
    }

    @Override
    public boolean delete(String id) {
        int i = this.ttCostTypeFineDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public List<TtCostTypeFineEntity> getActFineList(ActFineVo actFineVo) {
        Example example1 = new Example(TtCostTypeFineEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        if (ConstantEnum.TableTypeEnum.ACT_PRICE.getValue().equals(actFineVo.getTableType())) {
            criteria1.andEqualTo("actMethodCode", (Object)ConstantEnum.ActMethodEnum.SDFY.getValue());
        }
        if (StringUtil.isNotEmpty((CharSequence)actFineVo.getTableType())) {
            criteria1.andLike("tableType", "%" + actFineVo.getTableType() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)actFineVo.getCategoriesStatus())) {
            criteria1.andEqualTo("categoriesStatus", (Object)actFineVo.getCategoriesStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)actFineVo.getCategoriesCode())) {
            criteria1.andEqualTo("categoriesCode", (Object)actFineVo.getCategoriesCode());
        }
        List ttCostTypeFineEntities = this.selectExample(example1);
        return ttCostTypeFineEntities;
    }
}

